/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.http.ssl;

import com.dahuatech.hutool.core.util.ArrayUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.ssl.DefaultTrustManager;
import com.dahuatech.icc.util.StringUtils;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLSocketFactoryBuilder {
    public static final String SSL = "SSL";
    public static final String SSLv2 = "SSLv2";
    public static final String SSLv3 = "SSLv3";
    public static final String TLS = "TLS";
    public static final String TLSv1 = "TLSv1";
    public static final String TLSv11 = "TLSv1.1";
    public static final String TLSv12 = "TLSv1.2";
    private String protocol = "TLS";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers = new TrustManager[]{new DefaultTrustManager()};
    private SecureRandom secureRandom = new SecureRandom();

    public static SSLSocketFactoryBuilder create() {
        return new SSLSocketFactoryBuilder();
    }

    public SSLSocketFactoryBuilder setProtocol(String protocol) {
        if (StrUtil.isNotBlank(protocol)) {
            this.protocol = protocol;
        }
        return this;
    }

    public SSLSocketFactoryBuilder setTrustManagers(TrustManager ... trustManagers) {
        if (ArrayUtil.isNotEmpty(trustManagers)) {
            this.trustManagers = trustManagers;
        }
        return this;
    }

    public SSLSocketFactoryBuilder setKeyManagers(KeyManager ... keyManagers) {
        if (ArrayUtil.isNotEmpty(keyManagers)) {
            this.keyManagers = keyManagers;
        }
        return this;
    }

    public SSLSocketFactoryBuilder setSecureRandom(SecureRandom secureRandom) {
        if (null != secureRandom) {
            this.secureRandom = secureRandom;
        }
        return this;
    }

    public SSLSocketFactory build() throws NoSuchAlgorithmException, KeyManagementException {
        String version = System.getProperty("java.version");
        SSLContext sslContext = null;
        sslContext = !StringUtils.isEmpty(version) && version.startsWith("1.7") ? SSLContext.getInstance(TLSv12) : SSLContext.getInstance(this.protocol);
        sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        return sslContext.getSocketFactory();
    }
}

