/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.watcher;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.dada.response.watcher.ResponseWatchUtil;
import com.dada.response.watcher.entity.NetStatus;
import com.dada.response.watcher.entity.NetStatusCache;
import com.dada.response.watcher.http.pojo.ResponseBody;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.watcher.ResponseApi;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import retrofit2.Response;

public class ResponseHelper {
    public static final String TAG = "ResponseHelper";
    private static final String SPF_RESPONSE_REPOSITORY = "spf_response_repository";
    private static final String SPF_NETSTATUS = "netstatus";
    private static ResponseHelper instance;
    private NetStatusCache netStatus;
    private SharedPreferences netStatusPre;
    private Executor executor = Executors.newSingleThreadExecutor();
    private TagInterface tagInterface;

    public static ResponseHelper getInstance() {
        if (instance == null) {
            instance = new ResponseHelper();
        }
        return instance;
    }

    private ResponseHelper() {
        this.netStatusPre = ResponseWatchUtil.getContext().getSharedPreferences(SPF_RESPONSE_REPOSITORY, 0);
        String netStatusStr = this.netStatusPre.getString(SPF_NETSTATUS, "");
        if (!TextUtils.isEmpty((CharSequence)netStatusStr)) {
            try {
                this.netStatus = (NetStatusCache)JSON.parseObject((String)netStatusStr, NetStatusCache.class);
                ResponseWatchDebug.d(TAG, "netStatus  " + this.netStatus.toString());
            }
            catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences 1  " + e.getMessage());
                this.netStatus = new NetStatusCache();
            }
        } else {
            ResponseWatchDebug.d(TAG, "SharedPreferences new NetStatusCache");
            this.netStatus = new NetStatusCache();
        }
    }

    public synchronized void addWatchedData(String domain, String uri, int status) {
        Map<String, Long> statusMap = this.netStatus.statusMap;
        String key = String.format(Locale.CHINA, "%s;%s;%d", domain, uri, status);
        if (statusMap.containsKey(key)) {
            Long count = statusMap.get(key);
            if (null != count) {
                count = count + 1L;
                statusMap.put(key, count);
                this.syncSharedPreferences();
            }
        } else {
            statusMap.put(key, 1L);
            this.syncSharedPreferences();
        }
        ResponseWatchDebug.d(TAG, "addWatchedData " + this.netStatus);
    }

    void saveAndUpload() {
        try {
            this.sendResponseLog();
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d(TAG, "\u53d1\u9001\u5931\u8d25: " + e.getMessage());
        }
    }

    private synchronized void sendResponseLog() throws Exception {
        NetStatus netStatusToUpload = this.unZipNetStatus();
        ResponseWatchDebug.d(TAG, "\u8f6c\u6362\u5b8c\u7c7b\u578b");
        if (null == netStatusToUpload || ArrayUtils.isEmpty(netStatusToUpload.getMetrics())) {
            return;
        }
        NetStatusCache netStatusCopy = (NetStatusCache)this.netStatus.clone();
        ResponseWatchDebug.d(TAG, "\u5907\u4efd\u7684netStatus \uff1a " + this.netStatus.toString());
        ResponseWatchDebug.d(TAG, "\u5907\u4efd\u7684netStatusCopy\uff1a " + netStatusCopy.toString());
        ResponseWatchDebug.d(TAG, "\u771f\u6b63\u5f00\u59cb\u53d1\u9001 netStatusToUpload " + netStatusToUpload.toString());
        Response response = ResponseApi.getClientApi().collectMetrics(netStatusToUpload).execute();
        ResponseBody responseBody = (ResponseBody)response.body();
        if (null != responseBody && responseBody.isOk()) {
            this.resetNetStatusCache(netStatusCopy);
            ResponseWatchDebug.d(TAG, "\u8fd4\u56de\u4e86\u6211\u4eec\u7684 Response,\u5e76\u91cd\u7f6e netStatus " + this.netStatus.toString());
        } else if (null != responseBody) {
            ResponseWatchDebug.d(TAG, "\u5931\u8d25 code " + responseBody.getErrorCode() + " message" + responseBody.getErrorMsg());
        } else {
            ResponseWatchDebug.d(TAG, "\u7f51\u7edc\u4e0d\u901a");
        }
    }

    public void setTagInterface(TagInterface tagInterface) {
        this.tagInterface = tagInterface;
    }

    private NetStatus unZipNetStatus() {
        Map<String, Long> statusMap = this.netStatus.statusMap;
        if (statusMap.isEmpty()) {
            return null;
        }
        NetStatus.Tag tag = new NetStatus.Tag(this.tagInterface.getAppName(), this.tagInterface.getCityCode(), this.tagInterface.getDeviceId(), this.tagInterface.getDeviceId(), this.tagInterface.getDeviceId());
        ArrayList<NetStatus.Metric> metrics = new ArrayList<NetStatus.Metric>();
        for (String key : statusMap.keySet()) {
            String[] keyValue;
            Long count = statusMap.get(key);
            if (null == count || 0L == count || (keyValue = key.split(";")).length < 3) continue;
            String domain = keyValue[0];
            String uri = keyValue[1];
            int status = Integer.valueOf(keyValue[2]);
            NetStatus.Metric.Fields fields = new NetStatus.Metric.Fields(count);
            NetStatus.Metric.Tag tags = new NetStatus.Metric.Tag(domain, uri, status);
            NetStatus.Metric metric = new NetStatus.Metric(tags, fields);
            metrics.add(metric);
        }
        return new NetStatus(System.currentTimeMillis(), tag, metrics);
    }

    private void resetNetStatusCache(NetStatusCache netStatusCopy) {
        if (null == netStatusCopy || netStatusCopy.statusMap.isEmpty()) {
            return;
        }
        Map<String, Long> netStatusZipsCopy = netStatusCopy.statusMap;
        Map<String, Long> netStatusZipsCache = this.netStatus.statusMap;
        for (Map.Entry<String, Long> entryCopy : netStatusZipsCopy.entrySet()) {
            for (Map.Entry<String, Long> entry : netStatusZipsCache.entrySet()) {
                String keyCopy = entryCopy.getKey();
                String key = entry.getKey();
                Long valueCopy = entryCopy.getValue();
                Long value = entry.getValue();
                if (null == keyCopy || null == key || null == valueCopy || null == value) {
                    return;
                }
                if (!keyCopy.equals(key)) continue;
                entry.setValue(value - valueCopy);
            }
        }
        this.syncSharedPreferences();
    }

    private synchronized void syncSharedPreferences() {
        this.executor.execute(() -> {
            try {
                this.netStatusPre.edit().putString(SPF_NETSTATUS, JSON.toJSONString((Object)this.netStatus)).apply();
            }
            catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences save exception: " + e.getMessage());
            }
        });
    }
}

