package com.dada.response.watcher.interceptor;

import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.util.StringUtil;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;

import java.io.IOException;
import java.util.List;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by whh on 2019/6/20
 */
public class ResponseInterceptor implements Interceptor {
    private static final ResponseInterceptor instance = new ResponseInterceptor();

    public static ResponseInterceptor getInstance() {
        return instance;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        Request request = chain.request();
        Response response = chain.proceed(request);

        //#1 加注解方式
        //        val isWatched: Boolean = request.header("Response-watched") == "true"
        //        DevUtil.d("whh", "header: ${request.header("Response-watched")} isWatched: $isWatched")
        //        if (!isWatched)
        //            return response

        String domain = request.url().host();
        String uri = request.url().url().getPath();
        if (StringUtil.isEmpty(domain))
            return response;

        if (isMatchFilterUrl(uri)) {
            int status = response.code();
            ResponseWatchDebug.d("whh", "domain: " + domain + " uri: " + uri + " status: " + status);
            //加入监听
            ResponseHelper.getInstance().addWatchedData(domain, uri, status);
        }
        return response;
    }

    private boolean isMatchFilterUrl(String urlPathToMatch) {
        List<String> filterList = ResponseConfig.WATCHED_PATHS;
        if (ArrayUtils.isEmpty(filterList))
            return false;

        for (String s : filterList) {
            if (s.equals(urlPathToMatch))
                return true;
        }
        return false;
    }
}
