/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.watcher;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.dada.response.watcher.ResponseWatchUtil;
import com.dada.response.watcher.entity.NetStatus;
import com.dada.response.watcher.entity.NetStatusCache;
import com.dada.response.watcher.http.pojo.ResponseBody;
import com.dada.response.watcher.inter.TagInterface;
import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.watcher.ResponseApi;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import retrofit2.Response;

public class ResponseHelper {
    public static final String TAG = "ResponseHelper";
    private static final String SPF_RESPONSE_REPOSITORY = "spf_response_repository";
    private static final String SPF_NETSTATUS = "netstatus";
    private static ResponseHelper instance;
    private NetStatusCache netStatus;
    private SharedPreferences netStatusPre;
    private Executor executor = Executors.newSingleThreadExecutor();
    private TagInterface tagInterface;

    public static ResponseHelper getInstance() {
        if (instance == null) {
            instance = new ResponseHelper();
        }
        return instance;
    }

    private ResponseHelper() {
        this.netStatusPre = ResponseWatchUtil.getContext().getSharedPreferences(SPF_RESPONSE_REPOSITORY, 0);
        String netStatusStr = this.netStatusPre.getString(SPF_NETSTATUS, "");
        if (!TextUtils.isEmpty((CharSequence)netStatusStr)) {
            try {
                this.netStatus = (NetStatusCache)JSON.parseObject((String)netStatusStr, NetStatusCache.class);
                ResponseWatchDebug.d(TAG, "netStatus  " + this.netStatus.toString());
            }
            catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences 1  " + e.getMessage());
                this.netStatus = new NetStatusCache();
            }
        } else {
            ResponseWatchDebug.d(TAG, "SharedPreferences new NetStatusCache");
            this.netStatus = new NetStatusCache();
        }
    }

    public synchronized void addWatchedData(String domain, String uri, int status) {
        List<NetStatusCache.NetStatusZip> zipList = this.netStatus.getStatusList();
        String key = String.format(Locale.CHINA, "%s;%s;%d", domain, uri, status);
        for (int i = 0; i < zipList.size(); ++i) {
            NetStatusCache.NetStatusZip netStatusZip = zipList.get(i);
            if (null == netStatusZip || !key.equals(netStatusZip.getKey())) continue;
            int count = netStatusZip.getCount();
            netStatusZip.setCount(++count);
            this.syncSharedPreferences();
            return;
        }
        zipList.add(new NetStatusCache.NetStatusZip(key, 1));
        this.syncSharedPreferences();
    }

    void saveAndUpload() {
        try {
            this.sendResponseLog();
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d(TAG, "db save exception: " + e.getMessage());
        }
    }

    private synchronized void sendResponseLog() throws Exception {
        NetStatus netStatusToUpload = this.unZipNetStatus();
        ResponseWatchDebug.d(TAG, "\u8f6c\u6362\u5b8c\u7c7b\u578b");
        if (null == netStatusToUpload || ArrayUtils.isEmpty(netStatusToUpload.getMetrics())) {
            return;
        }
        NetStatusCache netStatusCopy = (NetStatusCache)this.netStatus.clone();
        ResponseWatchDebug.d(TAG, "\u771f\u6b63\u5f00\u59cb\u53d1\u9001");
        Response response = ResponseApi.getClientApi().collectMetrics(netStatusToUpload).execute();
        ResponseBody responseBody = (ResponseBody)response.body();
        if (null != responseBody && responseBody.isOk()) {
            ResponseWatchDebug.d(TAG, "\u8fd4\u56de\u4e86\u6211\u4eec\u7684 Response");
            this.resetNetStatusCache(netStatusCopy);
        } else if (null != responseBody) {
            ResponseWatchDebug.d(TAG, "\u5931\u8d25 code " + responseBody.getErrorCode() + " message" + responseBody.getErrorMsg());
        } else {
            ResponseWatchDebug.d(TAG, "\u7f51\u7edc\u4e0d\u901a");
        }
    }

    public void setTagInterface(TagInterface tagInterface) {
        this.tagInterface = tagInterface;
    }

    private NetStatus unZipNetStatus() {
        List<NetStatusCache.NetStatusZip> netStatusZips = this.netStatus.getStatusList();
        if (ArrayUtils.isEmpty(netStatusZips)) {
            return null;
        }
        NetStatus netStatus = new NetStatus();
        netStatus.setTime(System.currentTimeMillis());
        netStatus.getTags().setApp(this.tagInterface.getAppName());
        netStatus.getTags().setCity(this.tagInterface.getCityCode());
        netStatus.getTags().setDeviceId(this.tagInterface.getDeviceId());
        netStatus.getTags().setNetwork(this.tagInterface.getNetWork());
        netStatus.getTags().setOperator(this.tagInterface.getOperator());
        List<NetStatus.Metric> metrics = netStatus.getMetrics();
        for (int i = 0; i < netStatusZips.size(); ++i) {
            String[] keyValue;
            int count = netStatusZips.get(i).getCount();
            if (0 == count || (keyValue = netStatusZips.get(i).getKey().split(";")).length < 3) continue;
            String domain = keyValue[0];
            String uri = keyValue[1];
            int status = Integer.valueOf(keyValue[2]);
            NetStatus.Metric.Fields fields = new NetStatus.Metric.Fields(count);
            NetStatus.Metric.Tag tags = new NetStatus.Metric.Tag(domain, uri, status);
            NetStatus.Metric metric = new NetStatus.Metric(tags, fields);
            metrics.add(metric);
        }
        return netStatus;
    }

    private void resetNetStatusCache(NetStatusCache netStatusCopy) {
        if (null == netStatusCopy || ArrayUtils.isEmpty(netStatusCopy.getStatusList())) {
            return;
        }
        List<NetStatusCache.NetStatusZip> netStatusZipsCopy = netStatusCopy.getStatusList();
        List<NetStatusCache.NetStatusZip> netStatusZipsCache = this.netStatus.getStatusList();
        for (int i = 0; i < netStatusZipsCopy.size(); ++i) {
            for (int j = 0; j < netStatusZipsCache.size(); ++j) {
                NetStatusCache.NetStatusZip netStatusZip = netStatusZipsCache.get(j);
                NetStatusCache.NetStatusZip netStatusZipC = netStatusZipsCopy.get(j);
                if (null == netStatusZip || null == netStatusZipC || !netStatusZip.equals(netStatusZipsCopy.get(i))) continue;
                netStatusZip.setCount(netStatusZip.getCount() - netStatusZipC.getCount());
            }
        }
        this.syncSharedPreferences();
    }

    private synchronized void syncSharedPreferences() {
        this.executor.execute(() -> {
            try {
                this.netStatusPre.edit().putString(SPF_NETSTATUS, JSON.toJSONString((Object)this.netStatus)).apply();
            }
            catch (Exception e) {
                ResponseWatchDebug.d(TAG, "SharedPreferences save exception: " + e.getMessage());
            }
        });
    }
}

