package com.dada.response.watcher.watcher;

import android.content.Context;

import com.dada.response.watcher.util.ResponseWatchDebug;

import java.text.SimpleDateFormat;
import java.util.Locale;

import androidx.annotation.NonNull;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

import static com.dada.response.watcher.watcher.ResponseConfig.TRAVEL_TIME;

/**
 * Created by whh on 2019/6/21
 */
public class ResponseWorker extends Worker {

    private static final String WORKMANAGER_TAG = "response_tag";
    public static boolean isStopWork = false;
    private static Context context;

    public ResponseWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {
        try {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
            ResponseWatchDebug.d("whh", "ResponseWorker 执行了 at " + sim.format(System.currentTimeMillis()));
            ResponseHelper.getInstance().saveAndUpload();

            //轮询时间
            Thread.sleep(TRAVEL_TIME * 1000);

            //启动下一个 Worker
            if (!isStopWork) {
                startResponseWatchWorker(context);
            }

        } catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d("whh", "doWork " + e.getMessage());
        }

        return Result.success();
    }

    /**
     * 启动 worker，可以多次启动
     */
    public static void startResponseWatchWorker(Context context) {
        if (null == context)
            return;

        isStopWork = false;
        ResponseWorker.context = context;
        try {
            //启动 Response 监听
            WorkManager workManager = WorkManager.getInstance(context);
            //启动一个 WorkerManager,如果 queue 里面存在100个以上job会crash，workmanager代码的限制
            //可能导致崩溃增多
            //            workManager.cancelAllWorkByTag(WORKMANAGER_TAG);
            OneTimeWorkRequest responseRequest = new OneTimeWorkRequest.Builder(ResponseWorker.class)
                    .addTag(WORKMANAGER_TAG)
                    .build();
            workManager.enqueue(responseRequest);
            ResponseWatchDebug.d("whh", "startResponseWatchWorker ok");
        } catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d("whh", "startResponseWatchWorker " + e.getMessage());
        }

    }

    /**
     * 停止 worker
     */
    public static void stopResponseWatchWorker() {
        isStopWork = true;
        ResponseWatchDebug.d("whh", "stopResponseWatchWorker ok");
    }
}
