package com.dada.response.watcher.interceptor;

import com.dada.response.watcher.inter.VerifyHeaderInterface;
import com.dada.response.watcher.util.MD5;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.util.StringUtil;
import com.dada.response.watcher.watcher.ResponseApi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by whh on 2019/6/20
 */
public class HeaderInterceptor implements Interceptor {

    private VerifyHeaderInterface headerInterface;
    private static final HeaderInterceptor instance = new HeaderInterceptor();

    public static HeaderInterceptor getInstance() {
        return instance;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request original = chain.request();
        Request.Builder request = original.newBuilder();

        String timestamp = System.currentTimeMillis() + "";
        request.addHeader("timestamp", timestamp);
        Map<String, String> map = headerInterface.getHeader();
        map.put("timestamp", timestamp);
        String key;
        if (ResponseApi.isOnline()) {
            key = "1FD8B8A46755176E25510B8010FEC5E5";
        } else {
            key = "dada123456";
        }
        request.addHeader("sign", getMD5Sign(map, key));
        return chain.proceed(request.build());
    }

    public void setHeaderNeedInterface(VerifyHeaderInterface headerInterface) {
        this.headerInterface = headerInterface;
    }

    /**
     * 计算签名
     * 参数排序后加密，规则如下:<br>
     * 1.参数名ASCII码从小到大排序（字典序），尾部加上key；<br>
     * 2.如果参数的值为空不参与签名；<br>
     * 3.参数名区分大小写；<br>
     * <p>参考：https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_3</p>
     */
    public String getMD5Sign(Map<String, String> params, String key) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        params.remove("sign");
        String link = buildLink(params, key);
        ResponseWatchDebug.d("HeaderInterceptor", link);
        return MD5.getMD5(link).toUpperCase();
    }

    private static String buildLink(Map<String, String> params, String key) {
        if (params == null || params.isEmpty()) {
            return null;
        }

        List<Map.Entry<String, String>> paramsList = new ArrayList<>(params.entrySet());
        //对所有传入参数按照字段名的 ASCII 码从小到大排序（字典序）
        Collections.sort(paramsList, (o1, o2) -> (o1.getKey()).compareTo(o2.getKey()));

        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> param : paramsList) {
            if (!StringUtil.isEmpty(param.getKey()) || !StringUtil.isEmpty(param.getValue())) {
                sb.append(param.getKey()).append("=").append(param.getValue()).append("&");
            }
        }
        return sb.append("key=").append(key).toString();
    }
}
