package com.dada.response.watcher.http.pojo;

import com.dada.response.watcher.util.Json;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.util.StringUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class ResponseBody {
    public static final String ERROR_CODE_NO_GPS = "-100";

    private static final String OK = "ok";
    private String status;
    private String content;
    private String errorCode;
    private String errorMsg;

    private Object cache;

    public static ResponseBody failed(String errorMsg) {
        ResponseBody body = new ResponseBody();
        body.status = "fail";
        body.errorMsg = errorMsg;
        return body;
    }

    public static ResponseBody failedCode(String errorCode) {
        ResponseBody body = new ResponseBody();
        body.status = "fail";
        body.errorCode = errorCode;
        return body;
    }

    public static ResponseBody failed(String errorCode, String errorMsg) {
        ResponseBody body = new ResponseBody();
        body.status = "fail";
        body.errorCode = errorCode;
        body.errorMsg = errorMsg;
        return body;
    }

    public static ResponseBody success() {
        ResponseBody body = new ResponseBody();
        body.status = OK;
        return body;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return null == errorMsg ? "未知错误" : errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isOk() {
        return OK.equals(status);
    }

    void showDataFormatError(Exception e) {
        e.printStackTrace();
        ResponseWatchDebug.d("response", "数据解析出错！");
    }

    public <T> T getContentAs(Class<T> clzz) {
        try {
            return Json.fromJson(content, clzz);
        } catch (com.alibaba.fastjson.JSONException e) {
            showDataFormatError(e);
        }
        return null;
    }

    public JSONObject getContentAsObject() {
        try {
            return new JSONObject(content);
        } catch (JSONException e) {
            e.printStackTrace();
            showDataFormatError(e);
        }
        return new JSONObject();
    }

    public <T> List<T> getContentAsList(Class<T> clzz) {
        try {
            return Json.fromJsons(content, clzz);
        } catch (com.alibaba.fastjson.JSONException e) {
            e.printStackTrace();
            showDataFormatError(e);
        }
        return null;
    }

    public <T> T getContentChildAs(String key, Class<T> clzz) {
        try {
            return Json.fromJson(new JSONObject(content).getString(key), clzz);
        } catch (JSONException e) {
            e.printStackTrace();
            showDataFormatError(e);
        } catch (com.alibaba.fastjson.JSONException e) {
            e.printStackTrace();
            showDataFormatError(e);
        }
        return null;
    }

    public <T> List<T> getContentChildsAs(String key, Class<T> clzz) {
        try {
            JSONObject object = new JSONObject(content);
            String data = object.optString(key);
            if (!StringUtil.isEmpty(data)) {
                return Json.fromJsons(data, clzz);
            }
        } catch (JSONException e) {
            e.printStackTrace();
            showDataFormatError(e);
        } catch (com.alibaba.fastjson.JSONException e) {
            e.printStackTrace();
            showDataFormatError(e);
        }
        return null;
    }

    public <T> List<T> getContentChildsAs(Class<T> clzz) {
        try {
            return Json.fromJsons(content, clzz);
        } catch (com.alibaba.fastjson.JSONException e) {
            e.printStackTrace();
            showDataFormatError(e);
        }
        return null;
    }

    public Object getCache() {
        return cache;
    }

    public void setCache(Object cache) {
        this.cache = cache;
    }

    public ResponseBody() {
    }
}
