/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins;

import com.dabsquared.gitlabjenkins.GitLabMergeRequest;
import com.dabsquared.gitlabjenkins.GitLabPushRequest;
import com.dabsquared.gitlabjenkins.GitLabPushTrigger;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BallColor;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import hudson.util.RunList;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GitLabWebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(GitLabWebHook.class.getName());
    public static final String WEBHOOK_URL = "project";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return WEBHOOK_URL;
    }

    public void getDynamic(String projectName, StaplerRequest req, StaplerResponse res) {
        LOGGER.log(Level.FINE, "WebHook called.");
        String path = req.getRestOfPath();
        String[] splitURL = path.split("/");
        LinkedList<String> paths = new LinkedList<String>(Arrays.asList(splitURL));
        if (paths.size() > 0 && ((String)paths.get(0)).equals("")) {
            paths.remove(0);
        }
        String token = req.getParameter("token");
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)req.getInputStream(), (Writer)writer, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String theString = writer.toString();
        AbstractProject<?, ?> project = null;
        try {
            project = this.project(projectName, req, res);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "no such job {0}", projectName);
            throw HttpResponses.notFound();
        }
        if (paths.size() == 0) {
            this.generateBuild(theString, project, req, res);
            throw HttpResponses.ok();
        }
        String lastPath = (String)paths.get(paths.size() - 1);
        String firstPath = (String)paths.get(0);
        if (lastPath.equals("status.json") && !firstPath.equals("!builds")) {
            String commitSHA1 = (String)paths.get(1);
            this.generateStatusJSON(commitSHA1, project, req, res);
        } else if (lastPath.equals("build") || lastPath.equals("status.json") && firstPath.equals("!builds")) {
            this.generateBuild(theString, project, req, res);
        } else {
            AbstractBuild build;
            if (lastPath.equals("status.png")) {
                String branch = req.getParameter("ref");
                String commitSHA1 = req.getParameter("sha1");
                try {
                    this.generateStatusPNG(branch, commitSHA1, project, req, res);
                }
                catch (ServletException e) {
                    e.printStackTrace();
                    throw HttpResponses.error((int)500, (String)"Could not generate an image.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw HttpResponses.error((int)500, (String)"Could not generate an image.");
                }
            }
            if (firstPath.equals("builds") && !lastPath.equals("status.json") && (build = this.getBuildBySHA1(project, lastPath, true)) != null) {
                try {
                    res.sendRedirect2(Jenkins.getInstance().getRootUrl() + build.getUrl());
                }
                catch (IOException e) {
                    try {
                        res.sendRedirect2(Jenkins.getInstance().getRootUrl() + build.getBuildStatusUrl());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        throw HttpResponses.ok();
    }

    private void generateStatusJSON(String commitSHA1, AbstractProject project, StaplerRequest req, StaplerResponse rsp) {
        SCM scm = project.getScm();
        if (!(scm instanceof GitSCM)) {
            throw new IllegalArgumentException("This repo does not use git.");
        }
        AbstractBuild mainBuild = this.getBuildBySHA1(project, commitSHA1, true);
        JSONObject object = new JSONObject();
        object.put("sha", (Object)commitSHA1);
        if (mainBuild == null) {
            try {
                object.put("status", (Object)"pending");
                this.writeJSON(rsp, object);
                return;
            }
            catch (IOException e) {
                throw HttpResponses.error((int)500, (String)"Could not generate response.");
            }
        }
        object.put("id", (Object)mainBuild.getNumber());
        BallColor currentBallColor = mainBuild.getIconColor().noAnime();
        if (mainBuild.isBuilding()) {
            object.put("status", (Object)"running");
        } else if (currentBallColor == BallColor.BLUE) {
            object.put("status", (Object)"success");
        } else if (currentBallColor == BallColor.ABORTED) {
            object.put("status", (Object)"failed");
        } else if (currentBallColor == BallColor.DISABLED) {
            object.put("status", (Object)"failed");
        } else if (currentBallColor == BallColor.GREY) {
            object.put("status", (Object)"failed");
        } else if (currentBallColor == BallColor.NOTBUILT) {
            object.put("status", (Object)"failed");
        } else if (currentBallColor == BallColor.RED) {
            object.put("status", (Object)"failed");
        } else if (currentBallColor == BallColor.YELLOW) {
            object.put("status", (Object)"failed");
        } else {
            object.put("status", (Object)"failed");
        }
        try {
            this.writeJSON(rsp, object);
        }
        catch (IOException e) {
            throw HttpResponses.error((int)500, (String)"Could not generate response.");
        }
    }

    private void generateStatusPNG(String branch, String commitSHA1, AbstractProject project, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        SCM scm = project.getScm();
        if (!(scm instanceof GitSCM)) {
            throw new IllegalArgumentException("This repo does not use git.");
        }
        AbstractBuild mainBuild = null;
        if (branch != null) {
            mainBuild = this.getBuildByBranch(project, branch);
        } else if (commitSHA1 != null) {
            mainBuild = this.getBuildBySHA1(project, commitSHA1, false);
        }
        if (mainBuild == null) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/unknown.png");
            return;
        }
        BallColor currentBallColor = mainBuild.getIconColor().noAnime();
        if (mainBuild.isBuilding()) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/running.png");
        } else if (currentBallColor == BallColor.BLUE) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/success.png");
        } else if (currentBallColor == BallColor.ABORTED) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/unknown.png");
        } else if (currentBallColor == BallColor.DISABLED) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/unknown.png");
        } else if (currentBallColor == BallColor.GREY) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/unknown.png");
        } else if (currentBallColor == BallColor.NOTBUILT) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/unknown.png");
        } else if (currentBallColor == BallColor.RED) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/failed.png");
        } else if (currentBallColor == BallColor.YELLOW) {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/unknown.png");
        } else {
            rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + "/plugin/gitlab-jenkins/images/unknown.png");
        }
    }

    private void generateBuild(String data, AbstractProject project, StaplerRequest req, StaplerResponse rsp) {
        JSONObject json = JSONObject.fromObject((Object)data);
        LOGGER.log(Level.FINE, "data: {0}", json.toString(4));
        String objectType = json.optString("object_kind");
        if (objectType != null && objectType.equals("merge_request")) {
            this.generateMergeRequestBuild(data, project, req, rsp);
        } else {
            this.generatePushBuild(data, project, req, rsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePushBuild(String json, AbstractProject project, StaplerRequest req, StaplerResponse rsp) {
        GitLabPushRequest request = GitLabPushRequest.create(json);
        String repositoryUrl = request.getRepository().getUrl();
        if (repositoryUrl == null) {
            LOGGER.log(Level.WARNING, "No repository url found.");
            return;
        }
        Authentication old = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            GitLabPushTrigger trigger = (GitLabPushTrigger)project.getTrigger(GitLabPushTrigger.class);
            if (trigger == null) {
                return;
            }
            trigger.onPost(request);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateMergeRequestBuild(String json, AbstractProject project, StaplerRequest req, StaplerResponse rsp) {
        GitLabMergeRequest request = GitLabMergeRequest.create(json);
        if (request.getObjectAttribute().getState().equals("closed")) {
            return;
        }
        Authentication old = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            GitLabPushTrigger trigger = (GitLabPushTrigger)project.getTrigger(GitLabPushTrigger.class);
            if (trigger == null) {
                return;
            }
            trigger.onPost(request);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(old);
        }
    }

    private AbstractBuild getBuildBySHA1(AbstractProject project, String commitSHA1, boolean isMergeRequest) {
        AbstractBuild mainBuild = null;
        RunList builds = project.getBuilds();
        for (AbstractBuild build : builds) {
            BuildData data = (BuildData)build.getAction(BuildData.class);
            if (!isMergeRequest) {
                if (!data.getLastBuiltRevision().getSha1String().contains(commitSHA1)) continue;
                mainBuild = build;
                break;
            }
            if (!data.hasBeenBuilt(ObjectId.fromString((String)commitSHA1))) continue;
            mainBuild = build;
            break;
        }
        return mainBuild;
    }

    private AbstractBuild getBuildByBranch(AbstractProject project, String branch) {
        AbstractBuild mainBuild = null;
        RunList builds = project.getBuilds();
        for (AbstractBuild build : builds) {
            BuildData data = (BuildData)build.getAction(BuildData.class);
            Build branchBuild = (Build)data.getBuildsByBranchName().get("origin/" + branch);
            if (branchBuild == null) continue;
            int buildNumber = branchBuild.getBuildNumber();
            mainBuild = project.getBuildByNumber(buildNumber);
            break;
        }
        return mainBuild;
    }

    private void writeJSON(StaplerResponse rsp, JSONObject jsonObject) throws IOException {
        rsp.setContentType("application/json");
        PrintWriter w = rsp.getWriter();
        if (jsonObject == null) {
            w.write("null");
        } else {
            w.write(jsonObject.toString());
        }
        w.flush();
        w.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractProject<?, ?> project(String job, StaplerRequest req, StaplerResponse rsp) throws IOException, HttpResponses.HttpResponseException {
        AbstractProject p;
        SecurityContext orig = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            p = (AbstractProject)Jenkins.getInstance().getItemByFullName(job, AbstractProject.class);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
        if (p == null) {
            LOGGER.log(Level.FINE, "no such job {0}", job);
            throw HttpResponses.notFound();
        }
        return p;
    }
}

