/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.base.utils.LogUtils;

public class CssRoundBtn
extends RelativeLayout {
    private TextView tv;
    private ImageView iv;
    private String content;
    private float contentSize;
    private int contentColor;
    private float imgWidth;
    private float imgHeight;
    private Drawable imgSrc;
    private Drawable alertSrc;
    private Drawable innerLayoutSrc;
    private LinearLayout innerLinearLayout;
    private ImageView alertIcon;

    public CssRoundBtn(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.roundbtn);
        this.content = ta.getString(R.styleable.roundbtn_contentText);
        this.contentSize = ta.getDimension(R.styleable.roundbtn_contentTextSize, 0.0f);
        this.contentColor = ta.getColor(R.styleable.roundbtn_contentTextColor, 0);
        this.imgWidth = ta.getDimension(R.styleable.roundbtn_imgWidth, 0.0f);
        this.imgHeight = ta.getDimension(R.styleable.roundbtn_imgHeight, 0.0f);
        this.imgSrc = ta.getDrawable(R.styleable.roundbtn_imgSrc);
        this.alertSrc = ta.getDrawable(R.styleable.roundbtn_alertSrc);
        this.innerLayoutSrc = ta.getDrawable(R.styleable.roundbtn_innerLayoutBackground);
        ta.recycle();
        this.setGravity(15);
        this.tv = new TextView(context);
        this.iv = new ImageView(context);
        this.alertIcon = new ImageView(context);
        this.tv.setText((CharSequence)this.content);
        this.tv.setTextSize(0, this.contentSize);
        this.tv.setTextColor(this.contentColor);
        this.iv.setImageDrawable(this.imgSrc);
        this.alertIcon.setImageDrawable(this.alertSrc);
        this.innerLinearLayout = new LinearLayout(context);
        this.innerLinearLayout.setOrientation(0);
        this.innerLinearLayout.setGravity(17);
        this.innerLinearLayout.setBackground(this.innerLayoutSrc);
        this.innerLinearLayout.setId(this.getId());
        RelativeLayout.LayoutParams llParams = new RelativeLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams ivParam = new LinearLayout.LayoutParams((int)this.imgWidth, (int)this.imgHeight);
        this.innerLinearLayout.addView((View)this.iv, (ViewGroup.LayoutParams)ivParam);
        RelativeLayout.LayoutParams tvParam = new RelativeLayout.LayoutParams(-2, -2);
        tvParam.setMargins(CssRoundBtn.dp2px(context, 2.0f), 0, 0, 0);
        this.tv.setGravity(17);
        this.innerLinearLayout.addView((View)this.tv, (ViewGroup.LayoutParams)tvParam);
        this.addView((View)this.innerLinearLayout, (ViewGroup.LayoutParams)llParams);
        RelativeLayout.LayoutParams alertIconParam = new RelativeLayout.LayoutParams((int)this.imgWidth, (int)this.imgHeight);
        alertIconParam.addRule(1, this.innerLinearLayout.getId());
        alertIconParam.setMargins(CssRoundBtn.dp2px(context, 0.0f), -3, 0, 0);
        this.addView((View)this.alertIcon, (ViewGroup.LayoutParams)alertIconParam);
    }

    public void changeImg(Drawable drawable2) {
        this.iv.setImageDrawable(drawable2);
        this.invalidate();
    }

    public void setImgVisible(int visible) {
        this.iv.setVisibility(visible);
        this.invalidate();
    }

    public void changeTextColor(int color2) {
        this.tv.setTextColor(color2);
        this.invalidate();
    }

    public void changeBgColor(int bgColor, int strokeColor) {
        GradientDrawable mGroupDrawable = (GradientDrawable)this.getBackground();
        if (mGroupDrawable != null) {
            mGroupDrawable.setStroke(1, strokeColor);
            mGroupDrawable.setColor(bgColor);
        } else {
            LogUtils.i("no GradientDrawable ");
        }
        this.invalidate();
    }

    public void setText(String text) {
        this.tv.setText((CharSequence)text);
        this.invalidate();
    }

    public void setAlertIcon(Drawable src) {
        this.alertIcon.setImageDrawable(src);
        this.invalidate();
    }

    public void setAlertIconVisible(int visible) {
        this.alertIcon.setVisibility(visible);
        this.invalidate();
    }

    public static int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }
}

