/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.imageloader.disk;

import android.content.Context;
import android.graphics.Bitmap;
import com.css.sdk.cservice.imageloader.disk.DiskCache;
import com.css.sdk.cservice.imageloader.disk.DiskLruCache;
import com.css.sdk.cservice.utils.IoUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LruDiskCache
implements DiskCache {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final int MAX_SIZE = 0xA00000;
    private static final String DIR_NAME = "diskCache";
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    private static final String ERROR_ARG_NEGATIVE = " argument must be positive number";
    protected DiskLruCache cache;
    protected int bufferSize = 32768;
    protected Bitmap.CompressFormat compressFormat = DEFAULT_COMPRESS_FORMAT;
    protected int compressQuality = 100;

    public LruDiskCache(Context context) throws IOException {
        this(context, 0xA00000L);
    }

    public LruDiskCache(Context context, long cacheMaxSize) throws IOException {
        this(context, cacheMaxSize, 0);
    }

    public LruDiskCache(Context context, long cacheMaxSize, int cacheMaxFileCount) throws IOException {
        if (cacheMaxSize < 0L) {
            throw new IllegalArgumentException("cacheMaxSize argument must be positive number");
        }
        if (cacheMaxFileCount < 0) {
            throw new IllegalArgumentException("cacheMaxFileCount argument must be positive number");
        }
        if (cacheMaxSize == 0L) {
            cacheMaxSize = Long.MAX_VALUE;
        }
        if (cacheMaxFileCount == 0) {
            cacheMaxFileCount = Integer.MAX_VALUE;
        }
        this.initCache(this.getDiskCacheDir(context, DIR_NAME), cacheMaxSize, cacheMaxFileCount);
    }

    private File getDiskCacheDir(Context context, String uniqueName) {
        return new File(context.getFilesDir(), uniqueName);
    }

    private void initCache(File cacheDir, long cacheMaxSize, int cacheMaxFileCount) throws IOException {
        block2: {
            try {
                this.cache = DiskLruCache.open(cacheDir, 1, 1, cacheMaxSize, cacheMaxFileCount);
            }
            catch (IOException e) {
                if (this.cache != null) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String imageUri, InputStream imageStream) throws IOException {
        DiskLruCache.Editor editor = this.cache.edit(this.getKey(imageUri));
        if (editor == null) {
            return false;
        }
        BufferedOutputStream os = new BufferedOutputStream(editor.newOutputStream(0), this.bufferSize);
        boolean copied = false;
        try {
            copied = IoUtils.copyStream(imageStream, os, null, this.bufferSize);
        }
        finally {
            IoUtils.closeSilently(os);
            if (copied) {
                editor.commit();
            } else {
                editor.abort();
            }
        }
        return copied;
    }

    @Override
    public File getDirectory() {
        return this.cache.getDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File get(String imageUri) {
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.cache.get(this.getKey(imageUri));
            File file = snapshot == null ? null : snapshot.getFile(0);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String imageUri, Bitmap bitmap) throws IOException {
        DiskLruCache.Editor editor = this.cache.edit(this.getKey(imageUri));
        if (editor == null) {
            return false;
        }
        BufferedOutputStream os = new BufferedOutputStream(editor.newOutputStream(0), this.bufferSize);
        boolean savedSuccessfully = false;
        try {
            savedSuccessfully = bitmap.compress(this.compressFormat, this.compressQuality, (OutputStream)os);
        }
        finally {
            IoUtils.closeSilently(os);
        }
        if (savedSuccessfully) {
            editor.commit();
        } else {
            editor.abort();
        }
        return savedSuccessfully;
    }

    @Override
    public boolean remove(String imageUri) {
        try {
            return this.cache.remove(this.getKey(imageUri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.cache.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cache = null;
    }

    @Override
    public void clear() {
        try {
            this.cache.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.initCache(this.cache.getDirectory(), this.cache.getMaxSize(), this.cache.getMaxFileCount());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getKey(String imageUri) {
        return String.valueOf(imageUri.hashCode());
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setCompressQuality(int compressQuality) {
        this.compressQuality = compressQuality;
    }
}

