/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.data;

import android.content.Context;
import com.css.sdk.cservice.utils.LocalInfo;
import org.json.JSONObject;

public class FaqItem {
    public String id;
    public String questionZh;
    public String questionZhSimple;
    public String questionEn;
    public String title;

    public void parseJsonString(JSONObject jsonObject) throws Exception {
        this.id = jsonObject.getString("id");
        this.questionZh = jsonObject.getString("questionZh");
        this.questionEn = jsonObject.getString("questionEn");
        this.questionZhSimple = jsonObject.getString("questionZhSimple");
        this.title = jsonObject.optString("title", "");
    }

    public String toString() {
        return "FaqItem{id='" + this.id + '\'' + ", questionZh='" + this.questionZh + '\'' + ", questionZhSimple='" + this.questionZhSimple + '\'' + ", questionEn='" + this.questionEn + '\'' + '}';
    }

    public String getFaqTypeByLanguage(Context context) {
        String resultStr = "";
        switch (LocalInfo.getLanguage(context)) {
            case EN: {
                resultStr = this.questionEn;
                break;
            }
            case ZHSIMPLE: {
                resultStr = this.questionZhSimple;
                break;
            }
            case ZHTrandition: {
                resultStr = this.questionZh;
                break;
            }
            default: {
                resultStr = this.questionEn;
            }
        }
        return resultStr;
    }
}

