package com.css.sdk.cservice.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.utils.LogUtils;

import static android.view.Gravity.CENTER;
import static android.view.Gravity.CENTER_VERTICAL;

public class CssRoundBtn extends RelativeLayout {
    private TextView tv;
    private ImageView iv;
    private String content;
    private float contentSize;
    private int contentColor;
    private float imgWidth;
    private float imgHeight;
    private Drawable imgSrc;
    private Drawable alertSrc;
    private Drawable innerLayoutSrc;
    private LinearLayout innerLinearLayout;
    private ImageView alertIcon;

    public CssRoundBtn(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs,
                R.styleable.roundbtn);
        content = ta.getString(R.styleable.roundbtn_contentText);
        contentSize = ta.getDimension(R.styleable.roundbtn_contentTextSize, 0);
        contentColor = ta.getColor(R.styleable.roundbtn_contentTextColor, 0);

        imgWidth = ta.getDimension(R.styleable.roundbtn_imgWidth, 0);
        imgHeight = ta.getDimension(R.styleable.roundbtn_imgHeight, 0);
        imgSrc = ta.getDrawable(R.styleable.roundbtn_imgSrc);

        alertSrc = ta.getDrawable(R.styleable.roundbtn_alertSrc);
        innerLayoutSrc=ta.getDrawable(R.styleable.roundbtn_innerLayoutBackground);
        // 回收资源
        ta.recycle();

        this.setGravity(CENTER_VERTICAL);
        // view的创建
        tv = new TextView(context);
        iv = new ImageView(context);
        alertIcon = new ImageView(context);

        tv.setText(content);
        tv.setTextSize(TypedValue.COMPLEX_UNIT_PX, contentSize);
        tv.setTextColor(contentColor);
        iv.setImageDrawable(imgSrc);
        alertIcon.setImageDrawable(alertSrc);

        // LinearLayout
        innerLinearLayout = new LinearLayout(context);
        innerLinearLayout.setOrientation(LinearLayout.HORIZONTAL);
        innerLinearLayout.setGravity(CENTER);
        innerLinearLayout.setBackground(innerLayoutSrc);
        innerLinearLayout.setId(getId());
        LayoutParams llParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);

        // 宽高设置和位置设置
        LinearLayout.LayoutParams ivParam = new LinearLayout.LayoutParams((int) imgWidth, (int) imgHeight);
        innerLinearLayout.addView(iv, ivParam);


        LayoutParams tvParam = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        tvParam.setMargins(dp2px(context, 2), 0, 0, 0);
        tv.setGravity(CENTER);
        innerLinearLayout.addView(tv, tvParam);

        addView(innerLinearLayout, llParams);

        // alert icon

        LayoutParams alertIconParam = new LayoutParams((int) imgWidth, (int) imgHeight);
        alertIconParam.addRule(RelativeLayout.RIGHT_OF, innerLinearLayout.getId());
        alertIconParam.setMargins(dp2px(context, 0), -3, 0, 0);
        addView(alertIcon, alertIconParam);
    }

    public void changeImg(Drawable drawable) {
        iv.setImageDrawable(drawable);
        this.invalidate();
    }

    public void setImgVisible(int visible) {
        iv.setVisibility(visible);
        this.invalidate();
    }

    public void changeTextColor(int color) {
        tv.setTextColor(color);
        this.invalidate();
    }
    public void changeBgColor(int bgColor,int strokeColor){
        GradientDrawable mGroupDrawable = (GradientDrawable) this.getBackground();
        if (mGroupDrawable!=null){
            /*设置边框颜色和宽度*/
            mGroupDrawable.setStroke(1, strokeColor);
            /*设置整体背景颜色*/
            mGroupDrawable.setColor(bgColor);
        }else{
            LogUtils.i("no GradientDrawable ");
        }
        this.invalidate();
    }
    public void setText(String text) {
        tv.setText(text);
        this.invalidate();
    }

    public void setAlertIcon(Drawable src) {
        alertIcon.setImageDrawable(src);
        this.invalidate();
    }
    public void setAlertIconVisible(int visible) {
        alertIcon.setVisibility(visible);
        this.invalidate();
    }

    /**
     * Api方法转换
     *
     * @param dpValue
     * @return
     */
    public static int dp2px(Context context, float dpValue) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dpValue, context.getResources().getDisplayMetrics());
    }

    public static int px2dip(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }
}
