package com.css.sdk.cservice.request;

import com.css.sdk.BuildConfig;

public class URLConstant {

    /**
     * 查询用户反馈历史
     *
     * @param
     * @return
     */
    public static String getFqaHistory() {
        return BuildConfig.CSERVICE_API+BuildConfig.QUESTION_URL + "/list";
    }

    /**
     * 查询工单详情
     *
     */
    public static String getOderDetail() {
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/detail";
    }

    /**
     * 用户反馈问题
     *
     */
    public static String feedbackNew() {
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/new";
    }

    /**
     * 用户删除工单
     *
     */
    public static String deleteWorkOrder() {
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/delete";
    }

    /**
     * 用户反馈问题已解决
     *
     */
    public static String feedbackFinish() {
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/finish";
    }

    /**
     * 用户评价工单处理结果
     *
     */
    public static String evaluate() {
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/evaluate";
    }

    /**
     * 上传截图
     *
     */
    public static String uploadPic() {
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/uploadPic";
    }

    /**
     * 查询用户推荐fqa列表
     *
     */
    public static String getFaqList() {
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/faq/list";
    }


    /**
     * 查询产品的工单类型
     * added in 10023
     */
    public static String getTypeList() {
        return BuildConfig.CSERVICE_API+BuildConfig.QUESTION_URL + "/listType";
    }

    /**
     * 根据用户输入内容,查询输入结果
     */
    public static String getFaqMatch() {
        return BuildConfig.CSERVICE_API+BuildConfig.QUESTION_URL + "/faq/listMatch";
    }

    /**
     * 查看fqa内容
     *
     * @param
     * @return
     */
    public static String getFaqDetail() {
        return BuildConfig.CSERVICE_API+BuildConfig.QUESTION_URL + "/faq/detail";
    }

    /**
     * 评价fqa
     *
     */
    public static String evaluateFaq() {
        return BuildConfig.CSERVICE_API+BuildConfig.QUESTION_URL + "/faq/evaluate";
    }

    /**
     *  是否存在最新的回复
     * @return
     */
    public static String existNewReply(){
        return BuildConfig.CSERVICE_API +BuildConfig.QUESTION_URL+ "/existNewReply";
    }

    /**
     * 是否存在系统公告
     * @return
     *  added in 10056
     */
    public static String noticeList(){ return BuildConfig.CSERVICE_API +BuildConfig.SYSTEM_URL+ "/notice/list";}

    /**
     * 是否存在系统消息
     * @return
     *
     *  added in 10056
     */
    public static String systemMsgList(){ return BuildConfig.CSERVICE_API +BuildConfig.SYSTEM_URL+ "/message/list";}

    /**
     * 项目显示风格 -提交按钮，主色调
     * @return
     *  added in 10056
     */
    public static String getProductUIConfig(){ return BuildConfig.CSERVICE_API +BuildConfig.PRODUCT_URL+ "/config";}

    /**
     * 查询产品的可提交的工单类型
     * added in 10056
     */
    public static String getSubmitTypeList() {
        return BuildConfig.CSERVICE_API+BuildConfig.QUESTION_URL + "/types";
    }

    /**
     * 获得系统消息的详细信息
     * added in 10056
     */
    public static String getSystemMsgDetail() {
        return BuildConfig.CSERVICE_API+BuildConfig.SYSTEM_URL + "/message/detail";
    }
}
