package com.css.sdk.cservice.data;

import org.json.JSONObject;

/**
  *
  * @ProjectName:    cssdk
  * @Package:        com.css.sdk.cservice.data
  * @ClassName:      SystemMsgDetailEntity
  * @Description:    获得系统消息的详细信息
  * @Author:         wan
  * @CreateDate:     2021/1/20 8:36 PM
  * @UpdateUser:     wan
  * @UpdateDate:     2021/1/20 8:36 PM
  * @UpdateRemark:   更新说明：
  * @Version:        1.0
 */
public class SystemMsgDetailEntity {
    public String id;
    public String title;
    public SystemMsgType type;
    public String content;
    public String startTime;

    public void parseJsonString(JSONObject jsonObject) throws Exception {
        this.id = jsonObject.optString("id");
        this.title = jsonObject.optString("title");
        String typeStr = jsonObject.optString("type");
        if(typeStr.equals("TEXT")){
            this.type=SystemMsgType.TEXT;
        }else if(typeStr.equals("HTML")){
            this.type=SystemMsgType.HTML;
        }else {
            this.type=SystemMsgType.TEXT;
        }
        this.content = jsonObject.optString("content");
        this.startTime = jsonObject.optString("startTime");
    }

    public enum SystemMsgType{
        TEXT,HTML
    }

    @Override
    public String toString() {
        return "SystemMsgDetailEntity{" +
                "id='" + id + '\'' +
                ", title='" + title + '\'' +
                ", type=" + type +
                ", content='" + content + '\'' +
                ", startTime='" + startTime + '\'' +
                '}';
    }
}
