package com.css.sdk.cservice.data;

import android.content.Context;

import com.css.sdk.cservice.utils.LocalInfo;

import org.json.JSONObject;

public class FaqDetail {
    public String question;
    public String answer;
    public String format;
    public String title,content;

    public void parseJsonString(Context context, JSONObject jsonObject) throws Exception {
//        this.questionZh = jsonObject.getString("questionZh");
//        this.questionEn = jsonObject.getString("questionEn");
//        this.questionZhSimple = jsonObject.getString("questionZhSimple");
//        this.answerEn = jsonObject.getString("answerEn");
//        this.answerZh = jsonObject.getString("answerZh");
//        this.answerZhSimple = jsonObject.getString("answerZhSimple");
        if (LocalInfo.getLanguage(context) == LocalInfo.LocalLanguage.ZHSIMPLE) {
            this.question = jsonObject.getString("questionZhSimple");
            this.answer = jsonObject.getString("answerZhSimple");
        } else if (LocalInfo.getLanguage(context) == LocalInfo.LocalLanguage.ZHTrandition) {
            this.question = jsonObject.getString("questionZh");
            this.answer = jsonObject.getString("answerZh");
        } else {
            this.question = jsonObject.getString("questionEn");
            this.answer = jsonObject.getString("answerEn");
        }
        title=jsonObject.optString("title","");
        content=jsonObject.optString("content","");
        this.format = jsonObject.getString("format");
    }

    @Override
    public String toString() {
        return "FaqDetail{" +
                "question='" + question + '\'' +
                ", answer='" + answer + '\'' +
                ", format='" + format + '\'' +
                '}';
    }
}
