package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;


import com.css.sdk.R;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.userdata.GlobalData;

import java.util.List;

public class HorizonTabAdapter extends BaseAdapter {
    private List<FaqTypeItem> tags;
    private Context mContext;
    private int selectedId;

    public HorizonTabAdapter(Context mContext, List<FaqTypeItem> tags) {
        this.tags = tags;
        this.mContext = mContext;
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId;
    }

    @Override
    public int getCount() {
        return tags == null ? 0 : tags.size();
    }

    @Override
    public Object getItem(int position) {
        return tags.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(mContext).inflate(R.layout.css_horizontab_item, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.tagName = convertView.findViewById(R.id.css_tab_item_name);
            viewHolder.hightLight = convertView.findViewById(R.id.css_tab_item_highlight);
            convertView.setTag(viewHolder);
        }else{
            viewHolder= (ViewHolder) convertView.getTag();
        }
        viewHolder.tagName.setText(tags.get(position).type);
        if (position==selectedId){
            viewHolder.hightLight.setVisibility(View.VISIBLE);
            viewHolder.tagName.setTextSize(16);
//            viewHolder.tagName.setTextColor(mContext.getResources().getColor(R.color.css_default_blue));
            viewHolder.tagName.setTextColor(GlobalData.getUiColor());
            viewHolder.hightLight.setBackgroundColor(GlobalData.getUiColor());

        }else{
            viewHolder.hightLight.setVisibility(View.INVISIBLE);
            viewHolder.tagName.setTextSize(14);
            viewHolder.tagName.setTextColor(mContext.getResources().getColor(R.color.css_default_gray));
        }

        return convertView;
    }

    class ViewHolder {
        TextView tagName;
        View hightLight;
//        boolean selected;
    }
}
