package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.ToastHelper;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import static com.css.sdk.cservice.base.Constants.KEY_DETIAL_EVALUATE_RESULT;
import static com.css.sdk.cservice.base.Constants.REQUESTCODE_SUBMITSUCCESS_FQADETAIL;

public class SubmitSuccessActivity extends AbstractBaseActivity implements AdapterView.OnItemClickListener, View.OnClickListener {
    // gridview for faqTag
    private AbsListView relativeFaqsView;
    private SimpleTextGridViewAdapter gridViewAdapter;
    private LinearLayout LoadingView;
    private String feedbackResult;
    List<FaqItem> faqs = new ArrayList<FaqItem>();
    private String feedbackId = "";
    private LinearLayout refreshRoot;
    private LinearLayout faqRoot;
    // 每次gridview显示4个
    private int freashNum = 1;
    private List<FaqItem> subList;
    private TextView submitResult;
    private TextView refreshText;

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_submitsuccess;
    }

    @Override
    public void initView() {
        super.initView();
        showTitleClose(true);
        relativeFaqsView = findViewById(R.id.css_faqs_list);
        LoadingView = findViewById(R.id.css_loading_layout);
        relativeFaqsView.setOnItemClickListener(this);
        refreshRoot = findViewById(R.id.css_refreashqa_root);
        refreshRoot.setVisibility(View.INVISIBLE);
        refreshRoot.setOnClickListener(this);
        faqRoot = findViewById(R.id.css_recommandqa_root);
        submitResult = findViewById(R.id.css_submitsuccess_result);
        submitResult.setTextColor(GlobalData.getUiColor());
        refreshText=findViewById(R.id.css_refreashqa_tv);
        refreshText.setTextColor(GlobalData.getUiColor());
    }


    @Override
    public void initData() {
        if (faqs == null || faqs.size() <= 0) {
            faqRoot.setVisibility(View.GONE);
            return;
        } else {
            faqRoot.setVisibility(View.VISIBLE);
        }
        subList = getFaqList();
        if (subList == null || subList.size() <= 0) {
            return;
        }
        if (faqs.size() > 4) {
            refreshRoot.setVisibility(View.VISIBLE);
        }
        gridViewAdapter = new SimpleTextGridViewAdapter(this, subList);
        relativeFaqsView.setAdapter(gridViewAdapter);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        faqs.clear();
        feedbackResult = getIntent().getStringExtra("result");
        // 获得id 和matchfaqs
        try {
            JSONObject jsonObject = new JSONObject(feedbackResult);
            if (jsonObject.has("data")) {
                JSONObject data = jsonObject.getJSONObject("data");
                JSONArray items = data.getJSONArray("matchFaqs");
                feedbackId = data.optString("id");
                JSONObject row = null;
                for (int i = 0; i < items.length(); i++) {
                    row = items.getJSONObject(i);
                    FaqItem item = new FaqItem();
                    item.parseJsonString(row);
                    faqs.add(item);
                }
            } else {
                LogUtils.i("error in json");
            }
        } catch (Exception e) {
            LogUtils.i("error in json " + e.getMessage());
        }

    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        goToDetailWithResult(position);

    }

    private void goToDetailWithResult(int position) {
        Intent i = new Intent(SubmitSuccessActivity.this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, subList.get(position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, subList.get(position).title);
        i.putExtra(Constants.KEY_QU_ID, feedbackId);
        startActivityForResult(i, REQUESTCODE_SUBMITSUCCESS_FQADETAIL);
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.css_refreashqa_root) {
            subList = getFaqList();
            gridViewAdapter.setData(subList);
            gridViewAdapter.notifyDataSetChanged();
        }
    }

    public List getFaqList() {
        List<FaqItem> subList;
        // step1 如果正好满足4的倍数
        if (faqs.size() >= freashNum * 4) {
            subList = faqs.subList((freashNum - 1) * 4, freashNum * 4);
            freashNum++;
        } else {
            if ((freashNum - 1) * 4 == faqs.size()) {
                freashNum = 1;
                return getFaqList();
            } else {
                subList = faqs.subList((freashNum - 1) * 4, faqs.size());
                freashNum = 1;
            }
        }
        return subList;
    }


    private void commitFinish() {
        showLoading();
        BusinessRequest.fqaFinish(feedbackId, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        finish();
                        ToastHelper.showShortToastCenter(getResources().getString(R.string.css_string_thanks_for_evaluate));
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (LoadingView.isShown()) {
                    LoadingView.setVisibility(View.GONE);
                }
            }
        });

    }

    private void showLoading() {
        if (!LoadingView.isShown()) {
            LoadingView.setVisibility(View.VISIBLE);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (resultCode) {
            case REQUESTCODE_SUBMITSUCCESS_FQADETAIL:
                // ResultActivity的返回数据
                if (data.getBooleanExtra(KEY_DETIAL_EVALUATE_RESULT, false)) {
                    commitFinish();
                }

                break;
            default:
                LogUtils.w("Unexpected value: " + resultCode, new IllegalStateException("Unexpected value: " + resultCode));
        }
    }
}
