package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;

import java.util.List;

public class FaqListActivity extends AbstractBaseActivity {

    private AbsListView contentView;


    private boolean mLoading;
    private SimpleTextGridViewAdapter gridViewAdapter;
    private List<FaqItem> faqList;
    private LinearLayout loadingRoot;
    private EditText etSearch;
    private TextView cancelSearch;
    private TextView confirmSearch;
    private TextView nodataView;


    @Override
    protected void initExtraData() {

    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faqlist;
    }

    @Override
    public void initView() {
        super.initView();
        showTitleBack(true);
        showTitleLargeSearch(true);
        if (isLand) {
            contentView = findViewById(R.id.css_faqs_list);
        } else {
            contentView = findViewById(R.id.css_recommedfaq_listView);
        }
        loadingRoot = findViewById(R.id.css_loading_layout);

        etSearch = findViewById(R.id.css_title_search);
        cancelSearch = findViewById(R.id.css_title_search_cancel);
        confirmSearch = findViewById(R.id.css_title_search_confrim);
        nodataView = findViewById(R.id.css_nodata);
        cancelSearch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                etSearch.setText("");
            }
        });
        confirmSearch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String targetStr = etSearch.getText().toString().trim();
                requestData(targetStr);
            }
        });

        contentView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                goToFaqDetail(position);
            }
        });
    }

    private void goToFaqDetail(int position) {
        Intent i = new Intent(FaqListActivity.this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, faqList.get(position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, faqList.get(position).title);
        startActivity(i);
    }

    @Override
    public void initData() {
//        requestData("");
    }
//    private void setEmptyView(ListView listView) {
//        TextView tv = new TextView(this);
//        tv.setText(getResources().getString(R.string.css_text_nodata));
//        tv.setGravity(Gravity.CENTER);
//        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.FILL_PARENT, LinearLayout.LayoutParams.FILL_PARENT);
//        addContentView(tv, params);
//        listView.setEmptyView(tv);
//    }


    private void showEmptyView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!nodataView.isShown()) {
                    nodataView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    private void hideEmptyView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (nodataView.isShown()) {
                    nodataView.setVisibility(View.GONE);
                }
            }
        });
    }

    private void requestData(String content) {
        showLoading();
        hideEmptyView();
        BusinessRequest.getFaqMatchList(content, new RequestCallback<List<FaqItem>>() {
            @Override
            public void onSuccess(final List<FaqItem> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        faqList = result;
                        if (result.isEmpty()) {
                            showEmptyView();
                            contentView.setVisibility(View.GONE);
                            return;
                        }
                        contentView.setVisibility(View.VISIBLE);
                        gridViewAdapter = new SimpleTextGridViewAdapter(FaqListActivity.this, faqList);
                        contentView.setAdapter(gridViewAdapter);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                showEmptyView();
                hideLoading();
                showError(code);
            }
        });
    }


    private void showLoading() {
        mLoading = true;
        loadingRoot.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        if (!mLoading) return;
        mLoading = false;
        loadingRoot.setVisibility(View.GONE);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (mLoading && keyCode == KeyEvent.KEYCODE_BACK) {
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }
}
