/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.imageloader.core;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.webkit.MimeTypeMap;
import android.widget.ImageView;
import com.css.sdk.cservice.imageloader.core.ContentLengthInputStream;
import com.css.sdk.cservice.utils.ImageUtils;
import com.css.sdk.cservice.utils.IoUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class ImageDecorder {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    protected static final int BUFFER_SIZE = 32768;
    protected static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    protected static final int MAX_REDIRECT_COUNT = 5;
    protected final Context context;
    protected final int connectTimeout;
    protected final int readTimeout;

    public ImageDecorder(Context context) {
        this(context, 5000, 20000);
    }

    public ImageDecorder(Context context, int connectTimeout, int readTimeout) {
        this.context = context.getApplicationContext();
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public Bitmap decodeByStream(InputStream imageStream, ImageDecorderParams params) throws IOException {
        if (imageStream == null) {
            return null;
        }
        params.actualSize = ImageUtils.getImageSize(imageStream);
        imageStream = this.resetStream(imageStream, params.url);
        return this.decodeBitmap(imageStream, params);
    }

    public Bitmap decode(ImageDecorderParams params) throws IOException {
        String imageUrl = params.url;
        InputStream imageStream = this.getImageStream(imageUrl);
        return this.decodeByStream(imageStream, params);
    }

    protected InputStream resetStream(InputStream imageStream, String url) throws IOException {
        if (imageStream.markSupported()) {
            try {
                imageStream.reset();
                return imageStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IoUtils.closeSilently(imageStream);
        return this.getImageStream(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeBitmap(InputStream imageStream, ImageDecorderParams params) {
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = false;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inSampleSize = ImageUtils.calculateInSampleSize(params.actualSize, params.expectSize);
            bitmap = BitmapFactory.decodeStream((InputStream)imageStream, null, (BitmapFactory.Options)options);
        }
        catch (Exception exception) {
        }
        finally {
            IoUtils.closeSilently(imageStream);
        }
        return bitmap;
    }

    public InputStream getImageStream(String imageUri) throws IOException {
        if (imageUri.startsWith("https") || imageUri.startsWith("http")) {
            return this.getStreamFromNetwork(imageUri);
        }
        return this.getStreamFromFile(imageUri);
    }

    protected InputStream getStreamFromNetwork(String imageUri) throws IOException {
        InputStream imageStream;
        HttpURLConnection conn = this.createConnection(imageUri);
        for (int redirectCount = 0; conn.getResponseCode() / 100 == 3 && redirectCount < 5; ++redirectCount) {
            conn = this.createConnection(conn.getHeaderField("Location"));
        }
        try {
            imageStream = conn.getInputStream();
        }
        catch (IOException e) {
            IoUtils.readAndCloseStream(conn.getErrorStream());
            throw e;
        }
        if (!this.shouldBeProcessed(conn)) {
            IoUtils.closeSilently(imageStream);
            throw new IOException("Image request failed with response code " + conn.getResponseCode());
        }
        return new ContentLengthInputStream(new BufferedInputStream(imageStream, 32768), conn.getContentLength());
    }

    protected HttpURLConnection createConnection(String url) throws IOException {
        String encodedUrl = Uri.encode((String)url, (String)ALLOWED_URI_CHARS);
        HttpURLConnection conn = (HttpURLConnection)new URL(encodedUrl).openConnection();
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        return conn;
    }

    protected boolean shouldBeProcessed(HttpURLConnection conn) throws IOException {
        return conn.getResponseCode() == 200;
    }

    protected InputStream getStreamFromFile(String imageUri) throws IOException {
        if (this.isVideoFileUri(imageUri)) {
            return this.getVideoThumbnailStream(imageUri);
        }
        BufferedInputStream imageStream = new BufferedInputStream(new FileInputStream(imageUri), 32768);
        return new ContentLengthInputStream(imageStream, (int)new File(imageUri).length());
    }

    private boolean isVideoFileUri(String uri) {
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)uri);
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        return mimeType != null && mimeType.startsWith("video/");
    }

    @TargetApi(value=8)
    private InputStream getVideoThumbnailStream(String filePath) {
        Bitmap bitmap;
        if (Build.VERSION.SDK_INT >= 8 && (bitmap = ThumbnailUtils.createVideoThumbnail((String)filePath, (int)2)) != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
        return null;
    }

    public static class ImageDecorderParams {
        String url;
        ImageUtils.ImageSize actualSize;
        ImageUtils.ImageSize expectSize;
        ImageView imageView;
    }
}

