/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.business;

import android.content.Context;
import android.text.TextUtils;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.constant.SubmitEntryModelEnum;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.data.OrderDetail;
import com.css.sdk.cservice.data.Picture;
import com.css.sdk.cservice.data.ProductUIConfigEntity;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.css.sdk.cservice.data.SystemMsgEntity;
import com.css.sdk.cservice.data.SystemNoticeItem;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.cservice.request.HttpCallback;
import com.css.sdk.cservice.request.HttpRequest;
import com.css.sdk.cservice.request.URLConstant;
import com.css.sdk.cservice.userdata.AASHelper;
import com.css.sdk.cservice.userdata.GlobalData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

public class BusinessRequest {
    private static AtomicLong existIsCalledLastTime = new AtomicLong(0L);
    private static List<CSSExistNewReplyCallback> newReplyCallBacks = new CopyOnWriteArrayList<CSSExistNewReplyCallback>();

    public static void getSystemMsgDetail(String msgId, final RequestCallback<SystemMsgDetailEntity> callback) {
        String url = URLConstant.getSystemMsgDetail() + "?message_id=" + msgId + "&" + BusinessRequest.getCommonValue();
        LogUtils.i("getSystemMsgDetail : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONObject message = data.getJSONObject("message");
                    SystemMsgDetailEntity item = new SystemMsgDetailEntity();
                    item.parseJsonString(message);
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(item);
                    } else {
                        callback.onFail("", code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getSystemMsgDetail has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getSubmitFaqTypeList(final RequestCallback<List<FaqTypeItem>> callback) {
        String url = URLConstant.getSubmitTypeList() + "?" + BusinessRequest.getCommonValue();
        LogUtils.i("getSubmitFaqTypeList url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqTypeItem> list = new ArrayList<FaqTypeItem>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("types");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); ++i) {
                            row = items.getJSONObject(i);
                            FaqTypeItem item = new FaqTypeItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getSubmitFaqTypeList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("faqTypelist onResponedFail is " + code + " error " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getSystemNoticeList(final RequestCallback<ArrayList<SystemNoticeItem>> callback) {
        String url = URLConstant.noticeList() + "?" + BusinessRequest.getCommonValue();
        LogUtils.i("getSystemNoticeList : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray items = data.getJSONArray("notices");
                    JSONObject row = null;
                    ArrayList<SystemNoticeItem> list = new ArrayList<SystemNoticeItem>();
                    for (int i = 0; i < items.length(); ++i) {
                        row = items.getJSONObject(i);
                        SystemNoticeItem item = new SystemNoticeItem();
                        item.parseJsonString(row);
                        list.add(item);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getSystemNoticeList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getProductUIConfig(final RequestCallback<ProductUIConfigEntity> callback) {
        String url = URLConstant.getProductUIConfig() + "?" + BusinessRequest.getCommonValue();
        LogUtils.i("getProductUIConfig : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    ProductUIConfigEntity item = new ProductUIConfigEntity("", SubmitEntryModelEnum.NORMAL);
                    item.parseJsonString(data);
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(item);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getProductUIConfig has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getSystemMsgList(final RequestCallback<ArrayList<SystemMsgEntity>> callback) {
        String url = URLConstant.systemMsgList() + "?" + BusinessRequest.getCommonValue();
        LogUtils.i("getSystemMsgList : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray items = data.getJSONArray("messages");
                    JSONObject row = null;
                    ArrayList<SystemMsgEntity> list = new ArrayList<SystemMsgEntity>();
                    for (int i = 0; i < items.length(); ++i) {
                        row = items.getJSONObject(i);
                        SystemMsgEntity item = new SystemMsgEntity();
                        item.parseJsonString(row);
                        list.add(item);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getSystemMsgList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getHistoryList(int statusType, final RequestCallback<ArrayList<HistoryItem>> callback) {
        String url = URLConstant.getFqaHistory() + "?" + BusinessRequest.getCommonValue() + "&status_type=" + statusType;
        LogUtils.i("getHistoryList" + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray items = data.getJSONArray("questions");
                    JSONObject row = null;
                    ArrayList<HistoryItem> list = new ArrayList<HistoryItem>();
                    for (int i = 0; i < items.length(); ++i) {
                        row = items.getJSONObject(i);
                        HistoryItem item = new HistoryItem();
                        item.parseJsonString(row);
                        list.add(item);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getHistoryList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getDetail(long questionId, final RequestCallback<OrderDetail> callback) {
        String url = URLConstant.getOderDetail() + "?" + BusinessRequest.getCommonValue() + "&questionId=" + questionId;
        LogUtils.i("getDetail url : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("getDetail onResponseSuccess : " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    OrderDetail detail = new OrderDetail();
                    detail.parseJsonString(data);
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(detail);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getDetail has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("getDetail onResponedFail : code " + code + " msg " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void feedBackN(Context context, String questionId, List<Picture> pics, List<Picture> videos, List<Picture> cancelPics, int typeId, String type, String content, final RequestCallback<String> callback) {
        String url = URLConstant.feedbackNew();
        url = url + "?" + BusinessRequest.getCommonValue() + "&accept_media=Y&type_id=" + (typeId == -1 ? "" : Integer.valueOf(typeId)) + "&type=" + type + "&device_model=" + DeviceInfoHelper.getBuildModel().replace(" ", "-");
        try {
            String str = URLEncoder.encode(URLEncoder.encode(content, "UTF-8"), "UTF-8");
            url = url + "&content=" + str;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)questionId)) {
            url = url + "&questionId=" + questionId;
        }
        if (!pics.isEmpty()) {
            url = url + "&pics=" + BusinessRequest.list2String(pics);
        }
        if (!videos.isEmpty()) {
            url = url + "&videos=" + BusinessRequest.list2String(videos);
        }
        if (!cancelPics.isEmpty()) {
            url = url + "&cancelPics=" + BusinessRequest.list2String(cancelPics);
        }
        url = BusinessRequest.addDeviceInfoInUrl(context, url);
        LogUtils.i("feedBackN request url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("feedBackN onResponseSuccess result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    if (code == 200) {
                        callback.onSuccess(result);
                    } else if (code == 403) {
                        callback.onFail("feedback error ", 403);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("feedBackN has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("feedBackN onResponedFail code: " + code + " msg :" + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    private static void addMediaInfo(HashMap<String, String> maps, String tag, String content) {
        maps.put(tag, content);
    }

    private static String addDeviceInfoInUrl(Context context, String url) {
        url = url + "&memory=" + DeviceInfoHelper.getTotalMemory(context);
        url = url + "&memory_used=" + DeviceInfoHelper.getAvailMemory(context);
        url = url + "&net_type=" + DeviceInfoHelper.getNetWorkType(context);
        try {
            url = url + "&cpu_model=" + URLEncoder.encode(URLEncoder.encode(DeviceInfoHelper.getCpuInfo(), "UTF-8"), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private static String list2String(List<Picture> list) {
        StringBuilder sb = new StringBuilder();
        for (Picture picture : list) {
            sb.append(picture.getPicName()).append(",");
        }
        String result = sb.toString();
        return result.substring(0, result.length() - 1);
    }

    public static void delete(String questionId, final RequestCallback<String> callback) {
        String url = URLConstant.deleteWorkOrder() + "?" + BusinessRequest.getCommonValue() + "&questionId=" + questionId;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("delete has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void fqaFinish(String questionId, final RequestCallback<String> callback) {
        String url = URLConstant.feedbackFinish() + "?" + BusinessRequest.getCommonValue() + "&questionId=" + questionId;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("fqaFinish has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void evaluateWorkOrder(String questionId, boolean satisfy, final RequestCallback<String> callback) {
        String s = satisfy ? "y" : "n";
        String url = URLConstant.evaluate() + "?" + BusinessRequest.getCommonValue() + "&questionId=" + questionId + "&satisfied=" + s;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("evaluateWorkOrder has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void uploadPics(final List<String> files, final RequestCallback<Map<String, List<Picture>>> callback) {
        String requestURL = URLConstant.uploadPic();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("gameGuestId", GlobalData.getAasGgid());
        params.put("token", GlobalData.getAlyToken());
        HttpRequest.requestUploadByPost(requestURL, params, files, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    Picture pic;
                    int i;
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    JSONObject data = jsonObject.getJSONObject("data");
                    ArrayList<Picture> picList = new ArrayList<Picture>();
                    ArrayList<Picture> videoList = new ArrayList<Picture>();
                    if (data.has(Constants.JSON_PICNAME)) {
                        JSONArray picItems = data.getJSONArray(Constants.JSON_PICNAME);
                        picList = new ArrayList();
                        for (i = 0; i < picItems.length(); ++i) {
                            pic = new Picture();
                            pic.setPicName(picItems.get(i).toString());
                            pic.setUrl((String)files.get(i));
                            picList.add(pic);
                        }
                    }
                    if (data.has(Constants.JSON_VIDEONAME)) {
                        JSONArray videoItems = data.getJSONArray(Constants.JSON_VIDEONAME);
                        videoList = new ArrayList();
                        for (i = 0; i < videoItems.length(); ++i) {
                            pic = new Picture();
                            pic.setPicName(videoItems.get(i).toString());
                            pic.setUrl((String)files.get(i));
                            videoList.add(pic);
                        }
                    }
                    HashMap<String, ArrayList<Picture>> resultMap = new HashMap<String, ArrayList<Picture>>();
                    if (!videoList.isEmpty()) {
                        resultMap.put(Constants.JSON_VIDEONAME, videoList);
                    }
                    if (!picList.isEmpty()) {
                        resultMap.put(Constants.JSON_PICNAME, picList);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(resultMap);
                    } else {
                        callback.onFail("fail", code);
                    }
                    LogUtils.i(" uploadPics onResponseSuccess: result" + result);
                }
                catch (Throwable e) {
                    LogUtils.i(" uploadPics onResponseSuccess: error " + e.getMessage());
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqList(String typeId, final RequestCallback<List<FaqItem>> callback) {
        String url = URLConstant.getFaqList() + "?" + BusinessRequest.getCommonValue() + "&type_id=" + typeId + "&support_html=Y";
        LogUtils.i("faqlist url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqItem> list = new ArrayList<FaqItem>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("questions");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); ++i) {
                            row = items.getJSONObject(i);
                            FaqItem item = new FaqItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getFaqList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("faqlist onResponedFail is " + code + " error " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqTypeList(final RequestCallback<List<FaqTypeItem>> callback) {
        String url = URLConstant.getTypeList() + "?" + BusinessRequest.getCommonValue();
        LogUtils.i("faqTypelist url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqTypeItem> list = new ArrayList<FaqTypeItem>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("types");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); ++i) {
                            row = items.getJSONObject(i);
                            FaqTypeItem item = new FaqTypeItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getFaqList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("faqTypelist onResponedFail is " + code + " error " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqMatchList(String content, final RequestCallback<List<FaqItem>> callback) {
        String url = "";
        try {
            content = URLEncoder.encode(content, "utf-8");
            url = URLConstant.getFaqMatch() + "?" + BusinessRequest.getCommonValue() + "&content=" + content;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        LogUtils.i("getFaqMatchList url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    LogUtils.i("getFaqMatchList onResponseSuccess result is " + result);
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqItem> list = new ArrayList<FaqItem>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("faqs");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); ++i) {
                            row = items.getJSONObject(i);
                            FaqItem item = new FaqItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.i("getFaqMatchList onResponseSuccess has error  is " + e.getMessage());
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("getFaqMatchList onResponedFail  " + e.getMessage() + " code " + code);
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqDetail(final Context context, String faqId, final RequestCallback<FaqDetail> callback) {
        String url = URLConstant.getFaqDetail() + "?" + BusinessRequest.getCommonValue() + "&faqId=" + faqId;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("faqdetail result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    FaqDetail detail = new FaqDetail();
                    detail.parseJsonString(context, data);
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(detail);
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getFaqDetail has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static synchronized void getExistNewReply(CSSExistNewReplyCallback callback) {
        if (!newReplyCallBacks.contains(callback)) {
            newReplyCallBacks.add(callback);
        }
        if (existIsCalledLastTime.get() == 0L) {
            existIsCalledLastTime.set(System.currentTimeMillis());
        } else {
            long timeSpan = System.currentTimeMillis() - existIsCalledLastTime.get();
            if (timeSpan < 60000L) {
                return;
            }
            existIsCalledLastTime.set(System.currentTimeMillis());
        }
        String url = URLConstant.existNewReply() + "?" + BusinessRequest.getCommonValue();
        LogUtils.i("getExistNewReply url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("getExistNewReply result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    String existNewReply = data.optString("existNewReply");
                    if (code == 200 && isSuccess) {
                        BusinessRequest.notifyNewReplayCallback(existNewReply);
                    } else {
                        BusinessRequest.notifyNewReplayCallback(msg + " code " + code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getFaqDetail has error :" + e.getMessage(), e);
                    BusinessRequest.notifyNewReplayCallback(e.getMessage());
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                BusinessRequest.notifyNewReplayCallback(e.getMessage() + " code :" + code);
            }
        });
    }

    public static void getExistNewReplyInner(final CSSExistNewReplyCallback callback) {
        String url = URLConstant.existNewReply() + "?" + BusinessRequest.getCommonValue();
        LogUtils.i("getExistNewReply url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("getExistNewReply result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    String existNewReply = data.optString("existNewReply");
                    if (code == 200 && isSuccess) {
                        if (existNewReply.equals("Y")) {
                            callback.hasNewReplySuccess(true);
                        } else if (existNewReply.equals("N")) {
                            callback.hasNewReplySuccess(false);
                        }
                    } else {
                        callback.hasNewReplyFail(msg + " code " + code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("getFaqDetail has error :" + e.getMessage(), e);
                    callback.hasNewReplyFail(e.getMessage());
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.hasNewReplyFail(e.getMessage() + " code :" + code);
            }
        });
    }

    private static void notifyNewReplayCallback(String msg) {
        if (newReplyCallBacks.size() <= 0) {
            return;
        }
        for (CSSExistNewReplyCallback callback : newReplyCallBacks) {
            if (msg.equals("Y")) {
                callback.hasNewReplySuccess(true);
                continue;
            }
            if (msg.equals("N")) {
                callback.hasNewReplySuccess(false);
                continue;
            }
            callback.hasNewReplyFail(msg);
        }
    }

    public static void evaluateFqa(String faqId, boolean isHelp, final RequestCallback<String> callback) {
        String help = isHelp ? "y" : "n";
        String url = URLConstant.evaluateFaq() + "?" + BusinessRequest.getCommonValue() + "&faqId=" + faqId + "&help=" + help;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>(){

            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail(msg, code);
                    }
                }
                catch (Throwable e) {
                    LogUtils.w("evaluateFqa has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), -100);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    private void getDevicesInfo(Context context) {
        String totalMemory = DeviceInfoHelper.getTotalMemory(context);
        String availableMe = DeviceInfoHelper.getAvailMemory(context);
        String netWork = DeviceInfoHelper.getNetWorkType(context);
        String cpuType = DeviceInfoHelper.getCpuInfo();
    }

    private static String getCommonValue() {
        HashMap<String, String> values = new HashMap<String, String>();
        AASHelper.freshGgid();
        values.put("gameGuestId", GlobalData.getAasGgid() == null ? "" : GlobalData.getAasGgid());
        values.put("token", GlobalData.getAlyToken());
        values.put("platform", Constants.PLATFORM_ANDROID);
        values.put("pdtid", GlobalData.getProductId());
        values.put("product_version", DeviceInfoHelper.getAppVersion(GlobalData.getContext()));
        values.put("system_version", DeviceInfoHelper.getSystemVersion());
        values.put("sdk_version", "2.0.01.2");
        if (GlobalData.getContext() != null && GlobalData.getContext().getResources().getConfiguration().locale != null) {
            values.put("language", GlobalData.getContext().getResources().getConfiguration().locale.getLanguage());
        }
        String cpInfoStr = "";
        if (GlobalData.getCpInfo() != null) {
            cpInfoStr = "&" + BusinessRequest.map2Url(GlobalData.getCpInfo());
        }
        return BusinessRequest.map2Url(values) + cpInfoStr;
    }

    private static String map2Url(Map<String, String> map) {
        if (map == null || map.size() <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey() + "=" + entry.getValue());
            stringBuilder.append("&");
        }
        String finalStr = stringBuilder.toString().substring(0, stringBuilder.length() - 1);
        return finalStr;
    }
}

