/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.http;

import android.text.TextUtils;
import com.css.sdk.cservice.base.http.HttpClient;
import com.css.sdk.cservice.base.http.HttpResponse;
import com.css.sdk.cservice.base.http.HttpsClient;
import java.util.Map;

public class HttpsClientHelper {
    public static HttpResponse httpGet(String url, String userAgent) throws Exception {
        return HttpsClientHelper.httpSend("get", url, null, userAgent, null);
    }

    public static HttpResponse httpPost(String url, String requestBody, String userAgent) throws Exception {
        return HttpsClientHelper.httpSend("post", url, requestBody, userAgent, null);
    }

    public static HttpResponse httpPost(String url, String requestBody, String userAgent, String enctyType) throws Exception {
        return HttpsClientHelper.httpSend("post", url, requestBody, userAgent, enctyType);
    }

    public static HttpResponse httpPost(String url, String requestBody, Map<String, String> heardMap, String userAgent, String enctyType) throws Exception {
        return HttpsClientHelper.httpSend("post", url, requestBody, heardMap, userAgent, enctyType);
    }

    private static HttpResponse httpSend(String type, String url, String requestBody, String userAgent, String enctyType) throws Exception {
        HttpResponse body = null;
        HttpsClient client = HttpsClient.builder().setmHostName("").setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod(HttpClient.METHOD_POST);
        }
        if (!TextUtils.isEmpty((CharSequence)requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty((CharSequence)enctyType)) {
            client.setEnctyType(enctyType);
        }
        body = client.request();
        return body;
    }

    private static HttpResponse httpSend(String type, String url, String requestBody, Map<String, String> headerMap, String userAgent, String enctyType) throws Exception {
        HttpResponse body = null;
        HttpsClient client = HttpsClient.builder().setmHostName("").setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod("POST");
        }
        if (!TextUtils.isEmpty((CharSequence)requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty((CharSequence)enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (!TextUtils.isEmpty((CharSequence)enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (headerMap != null && headerMap.size() != 0) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                client.setRequestHeader(key, value);
            }
        }
        body = client.request();
        return body;
    }
}

