/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.adapter.PictureAlbumDirectoryAdapter;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;
import com.css.sdk.cservice.base.utils.Utils;
import com.css.sdk.cservice.data.ImageFloder;
import java.util.List;

public class FolderPopWindow
extends PopupWindow
implements View.OnClickListener {
    private Context context;
    private View view;
    private ListView listView;
    private PictureAlbumDirectoryAdapter adapter;
    private Animation animationIn;
    private Animation animationOut;
    private boolean isDismiss = false;
    private LinearLayout rootLl;
    private TextView pictureTitle;

    public FolderPopWindow(Context context) {
        this.context = context;
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.css_picture_pop_window, null);
        this.setContentView(this.view);
        this.setWidth(DeviceInfoHelper.getScreenWidth(context));
        this.setHeight(DeviceInfoHelper.getScreenHeight(context));
        this.setAnimationStyle(R.style.WindowStyle);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        this.setBackgroundDrawable((Drawable)new ColorDrawable(Color.argb((int)123, (int)0, (int)0, (int)0)));
        this.animationIn = AnimationUtils.loadAnimation((Context)context, (int)R.anim.css_album_show);
        this.animationOut = AnimationUtils.loadAnimation((Context)context, (int)R.anim.css_album_dismiss);
        this.rootLl = (LinearLayout)this.view.findViewById(R.id.css_lv_ll);
        this.adapter = new PictureAlbumDirectoryAdapter(context);
        this.listView = (ListView)this.view.findViewById(R.id.css_folder_list);
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.rootLl.setOnClickListener((View.OnClickListener)this);
    }

    public void bindFolder(List<ImageFloder> folders) {
        this.adapter.bindFolderData(folders);
    }

    public void setPictureTitleView(TextView picture_title) {
        this.pictureTitle = picture_title;
    }

    public void showAsDropDown(View anchor) {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                Rect rect = new Rect();
                anchor.getGlobalVisibleRect(rect);
                int h = anchor.getResources().getDisplayMetrics().heightPixels - rect.bottom;
                this.setHeight(h);
            }
            super.showAsDropDown(anchor);
            this.isDismiss = false;
            this.listView.startAnimation(this.animationIn);
            this.modifyTextViewDrawable(this.pictureTitle, Utils.getDrawable(this.context, R.drawable.css_arrow_up));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnItemClickListener(PictureAlbumDirectoryAdapter.OnItemClickListener onItemClickListener) {
        this.adapter.setOnItemClickListener(onItemClickListener);
    }

    public void dismiss() {
        if (this.isDismiss) {
            return;
        }
        this.modifyTextViewDrawable(this.pictureTitle, Utils.getDrawable(this.context, R.drawable.css_arrow_down));
        this.isDismiss = true;
        this.listView.startAnimation(this.animationOut);
        this.dismiss();
        this.animationOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                FolderPopWindow.this.isDismiss = false;
                if (Build.VERSION.SDK_INT <= 16) {
                    FolderPopWindow.this.dismiss4Pop();
                } else {
                    FolderPopWindow.super.dismiss();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void dismiss4Pop() {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                FolderPopWindow.super.dismiss();
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.css_lv_ll) {
            this.dismiss();
        }
    }

    public void modifyTextViewDrawable(TextView v, Drawable drawable2) {
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        v.setCompoundDrawables(null, null, drawable2, null);
    }
}

