/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.TextView;
import com.css.sdk.R;

public class CustomEditText
extends AppCompatEditText {
    private int maxLength;
    private TextView numHintTv;
    private boolean isPaste;
    private int selectionStart;
    private int selectionEnd;
    private int current;

    public CustomEditText(Context context) {
        super(context);
    }

    public CustomEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
    }

    public CustomEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.LimitEditText);
        if (arr != null) {
            this.maxLength = arr.getInt(R.styleable.LimitEditText_maxLength, 300);
            arr.recycle();
        }
    }

    public void setNumTextView(TextView view) {
        this.numHintTv = view;
        if (this.maxLength > 0 && view != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.maxLength).append("/").append(this.maxLength);
            this.numHintTv.setText((CharSequence)sb.toString());
            this.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void afterTextChanged(Editable s) {
                    if (CustomEditText.this.isPaste) {
                        CustomEditText.this.dealNumView(s);
                        CustomEditText.this.isPaste = false;
                    } else {
                        CustomEditText.this.dealNumView(s);
                    }
                    int lineCount = CustomEditText.this.getLineCount();
                }
            });
        }
    }

    private void dealNumView(Editable s) {
        this.current = this.maxLength - s.length();
        if (this.current >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.current).append("/").append(this.maxLength);
            this.numHintTv.setText((CharSequence)sb.toString());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("0/").append(this.maxLength);
            this.numHintTv.setText((CharSequence)sb.toString());
            this.selectionStart = this.getSelectionStart();
            this.selectionEnd = this.getSelectionEnd();
            int tempSelection = this.selectionEnd + this.current;
            s.delete(this.selectionStart + this.current, this.selectionEnd);
            this.setText((CharSequence)s);
            this.setSelection(tempSelection);
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        int imeActions = outAttrs.imeOptions & 0xFF;
        if ((imeActions & 6) != 0) {
            outAttrs.imeOptions ^= imeActions;
            outAttrs.imeOptions |= 6;
        }
        if ((outAttrs.imeOptions & 0x40000000) != 0) {
            outAttrs.imeOptions &= 0xBFFFFFFF;
        }
        return connection;
    }

    public boolean onTextContextMenuItem(int id2) {
        switch (id2) {
            case 0x1020022: {
                this.isPaste = true;
            }
        }
        return super.onTextContextMenuItem(id2);
    }
}

