/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.SystemMsgEntity;
import com.css.sdk.cservice.userdata.GlobalData;
import java.util.ArrayList;
import java.util.List;

public class SystemMsgListAdapter
extends BaseAdapter {
    private Context mContext;
    private List<SystemMsgEntity> dataList;

    public SystemMsgListAdapter(Context mContext, List<SystemMsgEntity> dataList) {
        this.mContext = mContext;
        this.dataList = dataList;
    }

    public int getCount() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.css_gridview_history_faq_item, parent, false);
            holder = new ViewHolder();
            holder.root = (RelativeLayout)convertView.findViewById(R.id.css_history_grideview_item_root);
            holder.content = (TextView)convertView.findViewById(R.id.css_item_content);
            holder.msg = (ImageView)convertView.findViewById(R.id.css_iv_item_history_msg);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        SystemMsgEntity item = this.dataList.get(position);
        holder.content.setText((CharSequence)item.title);
        if (item.status.equals(Constants.SYSTEM_MSG_UNREAD)) {
            this.faqNewMessage(holder);
        } else if (item.status.equals(Constants.SYSTEM_MSG_READED)) {
            this.faqReaded(holder);
        }
        return convertView;
    }

    public void setDataList(ArrayList<SystemMsgEntity> msgList) {
        this.dataList = msgList;
    }

    private void faqNewMessage(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(GlobalData.getUiAlphaColor());
        viewHolder.msg.setVisibility(0);
        viewHolder.content.setTextColor(GlobalData.getUiColor());
    }

    private void faqReaded(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(this.mContext.getResources().getColor(R.color.css_cocor_bg_gray));
        viewHolder.msg.setVisibility(8);
        viewHolder.content.setTextColor(this.mContext.getResources().getColor(R.color.css_default_text_dark_gray));
    }

    class ViewHolder {
        RelativeLayout root;
        TextView content;
        ImageView msg;

        ViewHolder() {
        }
    }
}

