/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.PopWindowEntity;
import com.css.sdk.cservice.userdata.GlobalData;
import java.util.ArrayList;
import java.util.List;

public class PopupListAdapter
extends BaseAdapter {
    private Context mContext;
    private List<PopWindowEntity> dataList;

    public PopupListAdapter(Context mContext, List<PopWindowEntity> dataList) {
        this.mContext = mContext;
        this.dataList = dataList;
    }

    public int getCount() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.css_simple_list_item, parent, false);
            holder = new ViewHolder();
            holder.content = (TextView)convertView.findViewById(R.id.css_simplelist_tv);
            holder.iv = (ImageView)convertView.findViewById(R.id.css_simplelist_iv);
            holder.notice = (ImageView)convertView.findViewById(R.id.css_simplelist_notice);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        PopWindowEntity item = this.dataList.get(position);
        holder.content.setText((CharSequence)item.content);
        holder.content.setTextColor(GlobalData.getUiColor());
        if (item.status.equals(Constants.SYSTEM_MSG_UNREAD)) {
            this.faqNewMessage(holder);
        } else if (item.status.equals(Constants.SYSTEM_MSG_READED)) {
            this.faqReaded(holder);
        }
        holder.iv.setImageResource(item.imgId);
        return convertView;
    }

    public void setDataList(ArrayList<PopWindowEntity> msgList) {
        this.dataList = msgList;
    }

    private void faqNewMessage(ViewHolder viewHolder) {
        viewHolder.notice.setVisibility(0);
    }

    private void faqReaded(ViewHolder viewHolder) {
        viewHolder.notice.setVisibility(4);
    }

    class ViewHolder {
        TextView content;
        ImageView iv;
        ImageView notice;

        ViewHolder() {
        }
    }
}

