/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.userdata.GlobalData;
import java.util.List;

public class HistoryGridViewAdapter
extends BaseAdapter {
    private Context mContext;
    private List<HistoryItem> dataList;

    public HistoryGridViewAdapter(Context mContext, List<HistoryItem> dataList) {
        this.mContext = mContext;
        this.dataList = dataList;
    }

    public void setDataList(List<HistoryItem> dataList) {
        this.dataList = dataList;
    }

    public int getCount() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.css_gridview_history_faq_item, parent, false);
            holder = new ViewHolder();
            holder.root = (RelativeLayout)convertView.findViewById(R.id.css_history_grideview_item_root);
            holder.content = (TextView)convertView.findViewById(R.id.css_item_content);
            holder.msg = (ImageView)convertView.findViewById(R.id.css_iv_item_history_msg);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        HistoryItem item = this.dataList.get(position);
        holder.content.setText((CharSequence)item.title);
        if (item.status.equals(Constants.QA_STATUS_PROCESSED)) {
            this.faqNewMessage(holder);
        } else if (item.status.equals(Constants.QA_STATUS_CLOSED)) {
            this.faqClose(holder);
        } else {
            this.faqDefault(holder);
        }
        return convertView;
    }

    private void faqNewMessage(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(GlobalData.getUiAlphaColor());
        viewHolder.msg.setVisibility(0);
        viewHolder.content.setTextColor(this.mContext.getResources().getColor(R.color.css_default_blue));
    }

    private void faqDefault(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(GlobalData.getUiAlphaColor());
        viewHolder.msg.setVisibility(8);
        viewHolder.content.setTextColor(this.mContext.getResources().getColor(R.color.css_default_text_color_black));
    }

    private void faqClose(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(this.mContext.getResources().getColor(R.color.css_default_gray));
        viewHolder.msg.setVisibility(8);
        viewHolder.content.setTextColor(this.mContext.getResources().getColor(R.color.css_default_text_dark_gray));
    }

    class ViewHolder {
        RelativeLayout root;
        TextView content;
        ImageView msg;

        ViewHolder() {
        }
    }
}

