/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.listener.ItemDeleteCallback;
import com.css.sdk.cservice.view.SlideItem;
import java.util.List;

public class HistoryAdapter
extends BaseAdapter {
    private List<HistoryItem> dataList;
    private Context context;
    private LayoutInflater inflater;
    private ItemDeleteCallback deleteCallback;

    public HistoryAdapter(Context context, List<HistoryItem> dataList) {
        this.dataList = dataList;
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public void bindData(List<HistoryItem> dataList) {
        this.dataList = dataList;
    }

    public int getCount() {
        return this.dataList == null ? 0 : this.dataList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object item;
        ViewHolder holder = null;
        if (convertView == null) {
            View content = this.inflater.inflate(R.layout.css_history_adapter_item_content, null);
            View menu = this.inflater.inflate(R.layout.css_history_adapter_item_menu, null);
            holder = new ViewHolder(content, menu);
            SlideItem slideItem = new SlideItem(this.context);
            slideItem.setContentView(content, menu);
            convertView = slideItem;
            convertView.setTag((Object)holder);
        } else {
            if (convertView instanceof SlideItem && (item = (SlideItem)((Object)convertView)).isOpen()) {
                item.closeMenu();
            }
            holder = (ViewHolder)convertView.getTag();
        }
        item = this.dataList.get(position);
        holder.content.setText((CharSequence)((HistoryItem)item).title);
        if (((HistoryItem)item).status.equals(Constants.QA_STATUS_PROCESSED)) {
            holder.newMsg.setVisibility(0);
            holder.solved.setVisibility(8);
            holder.content.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.css_color_red));
        } else if (((HistoryItem)item).status.equals(Constants.QA_STATUS_CLOSED)) {
            holder.solved.setVisibility(0);
            holder.newMsg.setVisibility(8);
            holder.content.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.css_color_text_hint));
        } else {
            holder.solved.setVisibility(8);
            holder.newMsg.setVisibility(8);
            holder.content.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.css_color_text_content));
        }
        holder.delete.setOnClickListener(new View.OnClickListener((HistoryItem)item){
            final /* synthetic */ HistoryItem val$item;
            {
                this.val$item = historyItem;
            }

            public void onClick(View v) {
                if (HistoryAdapter.this.deleteCallback != null) {
                    HistoryAdapter.this.deleteCallback.onDeleted(String.valueOf(this.val$item.id));
                }
            }
        });
        return convertView;
    }

    private void starAnim(View view) {
    }

    public void setDeleteCallback(ItemDeleteCallback deleteCallback) {
        this.deleteCallback = deleteCallback;
    }

    class ViewHolder {
        TextView delete;
        ImageView newMsg;
        TextView solved;
        TextView content;

        public ViewHolder(View center, View menu) {
            this.delete = (TextView)menu.findViewById(R.id.css_history_item_delete);
            this.newMsg = (ImageView)center.findViewById(R.id.css_new_msg);
            this.content = (TextView)center.findViewById(R.id.css_tv_history_content);
            this.solved = (TextView)center.findViewById(R.id.css_tv_solved);
        }
    }
}

