/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import com.css.sdk.R;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.userdata.GlobalData;
import java.util.ArrayList;
import java.util.List;

public class CssTextGridViewAdapter
extends BaseAdapter {
    private Context mContext;
    private List<ChoseFaqItem> data;
    private GridViewItemClickListener mListener;
    private List<FaqTypeItem> faqs;

    public CssTextGridViewAdapter(Context context, int faqTagId, List<FaqTypeItem> faqs, GridViewItemClickListener clickListener) {
        this.mContext = context;
        this.faqs = faqs;
        this.getData(faqTagId);
        this.mListener = clickListener;
    }

    private void getData(int faqTagId) {
        List dataStr = this.getTags();
        this.data = new ArrayList<ChoseFaqItem>();
        for (int i = 0; i < dataStr.size(); ++i) {
            ChoseFaqItem faqItem = new ChoseFaqItem(i, (String)dataStr.get(i));
            if (faqTagId == i) {
                faqItem.checked = true;
            }
            this.data.add(faqItem);
        }
    }

    private List getTags() {
        if (this.faqs == null || this.faqs.size() <= 0) {
            return new ArrayList();
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (FaqItem faqItem : this.faqs) {
            strings.add(faqItem.getFaqTypeByLanguage(this.mContext));
        }
        return strings;
    }

    public int getCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.css_gridview_faqtag_item, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.content = (CheckBox)convertView.findViewById(R.id.css_item_content);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        final ChoseFaqItem choseItem = this.data.get(position);
        viewHolder.content.setText((CharSequence)choseItem.name);
        viewHolder.content.setBackground(this.mContext.getResources().getDrawable(R.drawable.css_qa_type_bg_default));
        if (choseItem.checked) {
            viewHolder.content.setChecked(true);
            this.changeBgColor(GlobalData.getUiColor(), GlobalData.getUiColor(), viewHolder.content);
            viewHolder.content.setTextColor(-1);
        } else {
            viewHolder.content.setChecked(false);
            this.changeBgColor(this.mContext.getResources().getColor(R.color.css_color_text_gray), this.mContext.getResources().getColor(R.color.css_color_text_gray), viewHolder.content);
            viewHolder.content.setTextColor(-1);
        }
        viewHolder.content.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CssTextGridViewAdapter.this.mListener.onGridItemClick(position);
                CssTextGridViewAdapter.this.refreshData(choseItem);
            }
        });
        return convertView;
    }

    private void refreshData(ChoseFaqItem selected) {
        for (ChoseFaqItem faqItem : this.data) {
            if (selected.id != faqItem.id) {
                faqItem.checked = false;
                continue;
            }
            faqItem.checked = true;
        }
        this.notifyDataSetChanged();
    }

    private void changeCheckBoxStyle() {
    }

    private void changeBgColor(int bgColor, int strokeColor, CheckBox checkBox) {
        GradientDrawable mGroupDrawable = (GradientDrawable)checkBox.getBackground();
        if (mGroupDrawable != null) {
            mGroupDrawable.setStroke(1, strokeColor);
            mGroupDrawable.setColor(bgColor);
        } else {
            LogUtils.i("no GradientDrawable ");
        }
    }

    class ChoseFaqItem {
        int id;
        String name;
        boolean checked;

        ChoseFaqItem(int id2, String name) {
            this.id = id2;
            this.name = name;
        }
    }

    class ViewHolder {
        CheckBox content;

        ViewHolder() {
        }
    }

    public static interface GridViewItemClickListener {
        public void onGridItemClick(int var1);
    }
}

