/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.qmuiteam.qmui.widget.QMUITopBarLayout;
import com.qmuiteam.qmui.widget.dialog.QMUITipDialog;

public class SystemMsgDetailActvity
extends AbstractBaseActivity {
    private TextView answerTv;
    private TextView timeTv;
    private SystemMsgDetailEntity detail;
    private String msgTitle = "";
    private String msgId = "";
    QMUITopBarLayout mTopBarLayout;
    private QMUITipDialog tipDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        this.msgId = this.getIntent().getStringExtra(Constants.KEY_DETAIL_ID);
        this.msgTitle = this.getIntent().getStringExtra(Constants.KEY_DETAIL_NAME);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_system_msg_detail_actvity;
    }

    @Override
    public void initView() {
        this.mTopBarLayout = (QMUITopBarLayout)this.findViewById(R.id.topbar);
        if (this.msgTitle.length() >= 60) {
            String substring = this.msgTitle.substring(0, 60);
            this.msgTitle = substring + "\n" + this.msgTitle.substring(60, this.msgTitle.length());
        }
        this.answerTv = (TextView)this.findViewById(R.id.css_answer);
        this.timeTv = (TextView)this.findViewById(R.id.css_time);
        this.initTopbar();
    }

    private void initTopbar() {
        this.mTopBarLayout.addRightImageButton(R.drawable.css_icon_close_small, R.drawable.css_icon_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SystemMsgDetailActvity.this.finish();
            }
        });
        this.updateTitle(this.msgTitle);
    }

    public void finish() {
        Intent intent = new Intent();
        intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.SYSTEM_MSG_READED);
        intent.putExtra(Constants.KEY_ORDER_ID, this.msgId);
        this.setResult(19, intent);
        super.finish();
    }

    private void updateTitle(String title) {
        if (title != null && !title.equals("")) {
            this.mTopBarLayout.setTitle(title);
        }
    }

    @Override
    public void initData() {
        this.requestData();
    }

    private void requestData() {
        this.showLoading();
        BusinessRequest.getSystemMsgDetail(this.msgId, new RequestCallback<SystemMsgDetailEntity>(){

            @Override
            public void onSuccess(final SystemMsgDetailEntity result) {
                SystemMsgDetailActvity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        SystemMsgDetailActvity.this.hideLoading();
                        SystemMsgDetailActvity.this.detail = result;
                        if (!TextUtils.isEmpty((CharSequence)((SystemMsgDetailActvity)SystemMsgDetailActvity.this).detail.title)) {
                            SystemMsgDetailActvity.this.answerTv.setText((CharSequence)((SystemMsgDetailActvity)SystemMsgDetailActvity.this).detail.content);
                            SystemMsgDetailActvity.this.answerTv.setVisibility(0);
                            SystemMsgDetailActvity.this.timeTv.setText((CharSequence)((SystemMsgDetailActvity)SystemMsgDetailActvity.this).detail.startTime);
                        } else {
                            SystemMsgDetailActvity.this.timeTv.setVisibility(8);
                            SystemMsgDetailActvity.this.answerTv.setVisibility(8);
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                SystemMsgDetailActvity.this.hideLoading();
                SystemMsgDetailActvity.this.showError(code);
            }
        });
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SystemMsgDetailActvity.this.tipDialog.dismiss();
            }
        });
    }

    private void showLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SystemMsgDetailActvity.this.tipDialog = new QMUITipDialog.Builder((Context)SystemMsgDetailActvity.this).setIconType(1).setTipWord((CharSequence)SystemMsgDetailActvity.this.getResources().getString(R.string.css_string_loading)).create();
                SystemMsgDetailActvity.this.tipDialog.show();
            }
        });
    }
}

