/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.BaseActivity;
import com.css.sdk.cservice.adapter.ImagePagerAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.view.CViewPager;
import java.util.ArrayList;

public class PreviewActivity
extends BaseActivity {
    private ArrayList<String> mImages;
    private ArrayList<String> selectImages;
    private int maxNum;
    private int position;
    private int type;
    private TextView selectTv;
    private TextView confirmTv;
    private TextView indicatorTv;
    private CViewPager viewPager;
    private BitmapDrawable mSelectDrawable;
    private BitmapDrawable mUnSelectDrawable;
    private boolean isConfirm = false;
    private RelativeLayout bottomBarRl;
    private RelativeLayout backBtn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.css_activity_preview_image);
        Bundle b = this.getIntent().getExtras();
        if (b != null) {
            this.maxNum = b.getInt(Constants.KEY_MAX_NUM);
            this.position = b.getInt(Constants.KEY_POSITION);
            this.mImages = b.getStringArrayList(Constants.KEY_ALL_PICS);
            this.selectImages = b.getStringArrayList(Constants.KEY_SELECTED_PICS);
            this.type = b.getInt(Constants.KEY_PREVIEW_TYPE, 1);
        }
        Resources resources = this.getResources();
        Bitmap selectBitmap = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.css_pic_checked);
        this.mSelectDrawable = new BitmapDrawable(resources, selectBitmap);
        this.mSelectDrawable.setBounds(0, 0, selectBitmap.getWidth(), selectBitmap.getHeight());
        Bitmap unSelectBitmap = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.css_pic_uncheck);
        this.mUnSelectDrawable = new BitmapDrawable(resources, unSelectBitmap);
        this.mUnSelectDrawable.setBounds(0, 0, unSelectBitmap.getWidth(), unSelectBitmap.getHeight());
        this.initView();
    }

    private void initView() {
        this.selectTv = (TextView)this.findViewById(R.id.css_tv_select);
        this.confirmTv = (TextView)this.findViewById(R.id.css_tv_confirm);
        this.indicatorTv = (TextView)this.findViewById(R.id.css_tv_indicator);
        this.viewPager = (CViewPager)this.findViewById(R.id.css_vp_image);
        this.bottomBarRl = (RelativeLayout)this.findViewById(R.id.css_rl_bottom_bar);
        this.backBtn = (RelativeLayout)this.findViewById(R.id.css_title_back);
        this.backBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewActivity.this.finish();
            }
        });
        if (this.type == Constants.PREVIEW_TYPE_SELECT) {
            this.confirmTv.setVisibility(0);
            this.bottomBarRl.setVisibility(0);
            StringBuilder sb = new StringBuilder();
            sb.append(this.getString(R.string.css_string_finish)).append(this.selectImages.size()).append("/").append(this.maxNum).append(")");
            this.confirmTv.setText((CharSequence)sb.toString());
            this.selectTv.setVisibility(0);
        } else if (this.type == Constants.PREVIEW_TYPE_VIEW) {
            this.bottomBarRl.setVisibility(8);
            this.confirmTv.setVisibility(8);
            this.selectTv.setVisibility(8);
        }
        this.confirmTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PreviewActivity.this.type == Constants.PREVIEW_TYPE_SELECT) {
                    PreviewActivity.this.isConfirm = true;
                    PreviewActivity.this.finish();
                }
            }
        });
        this.indicatorTv.setText((CharSequence)(this.position + 1 + "/" + this.mImages.size()));
        this.selectTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewActivity.this.clickSelect();
            }
        });
        ImagePagerAdapter adapter = new ImagePagerAdapter((Context)this, this.mImages);
        this.viewPager.setAdapter(adapter);
        this.viewPager.setCurrentItem(this.position);
        this.changeSelect(this.mImages.get(this.position));
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                PreviewActivity.this.indicatorTv.setText((CharSequence)(position + 1 + "/" + PreviewActivity.this.mImages.size()));
                PreviewActivity.this.changeSelect((String)PreviewActivity.this.mImages.get(position));
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void changeSelect(String image) {
        if (this.type == Constants.PREVIEW_TYPE_SELECT) {
            this.selectTv.setSelected(this.selectImages.contains(image));
            this.setSelectImageCount(this.selectImages.size());
        }
    }

    private void setSelectImageCount(int count) {
        if (count == 0) {
            this.confirmTv.setEnabled(false);
            StringBuilder sb = new StringBuilder();
            sb.append(this.getString(R.string.css_string_finish)).append("(0/").append(this.maxNum).append(")");
            this.confirmTv.setText((CharSequence)sb.toString());
        } else {
            this.confirmTv.setEnabled(true);
            if (this.maxNum > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getString(R.string.css_string_finish)).append("(").append(count).append("/").append(this.maxNum).append(")");
                this.confirmTv.setText((CharSequence)sb.toString());
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getString(R.string.css_string_finish)).append("(").append(count).append(")");
                this.confirmTv.setText((CharSequence)sb.toString());
            }
        }
    }

    private void clickSelect() {
        int position = this.viewPager.getCurrentItem();
        if (this.mImages != null && this.mImages.size() > position) {
            String image = this.mImages.get(position);
            if (this.selectImages.contains(image)) {
                this.selectImages.remove(image);
            } else if (this.selectImages.size() < this.maxNum) {
                this.selectImages.add(image);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getString(R.string.css_string_chose_at_most)).append(" ").append(this.maxNum).append(" ").append(this.getString(R.string.css_string_sheet));
                ToastUtil.showToastTip(this.getApplicationContext(), sb.toString(), false);
            }
            this.changeSelect(image);
        }
    }

    public void finish() {
        if (this.type == Constants.PREVIEW_TYPE_SELECT) {
            Intent intent = new Intent();
            intent.putExtra("is_confirm", this.isConfirm);
            intent.putExtra(Constants.KEY_SELECTED_PICS, this.selectImages);
            this.setResult(18, intent);
        }
        super.finish();
    }
}

