/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.design.widget.TabLayout;
import android.text.TextUtils;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.FaqDetailActvity;
import com.css.sdk.cservice.activity.FaqListActivity;
import com.css.sdk.cservice.activity.FeedBackActivity;
import com.css.sdk.cservice.activity.HistoryActivity;
import com.css.sdk.cservice.activity.SystemMsgActivity;
import com.css.sdk.cservice.adapter.HorizonTabAdapter;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.constant.SubmitEntryModelEnum;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.data.SystemMsgEntity;
import com.css.sdk.cservice.data.SystemNoticeItem;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.view.CommonDialog;
import com.css.sdk.cservice.view.CssRoundBtn;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FaqActivity
extends AbstractBaseActivity {
    private List<FaqItem> faqs = new ArrayList<FaqItem>();
    List<FaqTypeItem> faqTypeItems;
    private ListView verticalTabs;
    private HorizonTabAdapter horizonTabAdapter;
    private TabLayout mTab;
    private AbsListView tabsContentView;
    private CssRoundBtn qaHistoryBtn;
    private CssRoundBtn qaSubmitBtn;
    private SimpleTextGridViewAdapter contentViewAdapter;
    private LinearLayout loadingView;
    private TextView nodataView;
    private Map<String, CommonDialog> noticeDialogs = new LinkedHashMap<String, CommonDialog>();
    CommonDialog targetDialog = null;
    String targetId = "";
    private boolean newSevicesReply;

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq;
    }

    @Override
    public void initView() {
        super.initView();
        if (this.isLand) {
            this.verticalTabs = (ListView)this.findViewById(R.id.css_horizontab);
        } else {
            this.mTab = (TabLayout)this.findViewById(R.id.css_tabs);
            this.mTab.setSelectedTabIndicatorColor(GlobalData.getUiColor());
            this.mTab.setTabTextColors(this.getResources().getColor(R.color.css_color_text_gray), GlobalData.getUiColor());
        }
        this.initCommonView();
    }

    private void initCommonView() {
        this.qaSubmitBtn = (CssRoundBtn)this.findViewById(R.id.css_btn_submit_qa);
        this.qaHistoryBtn = (CssRoundBtn)this.findViewById(R.id.css_faq_rightbtn);
        this.qaHistoryBtn.changeBgColor(-1, GlobalData.getUiColor());
        this.qaHistoryBtn.changeTextColor(GlobalData.getUiColor());
        this.qaSubmitBtn.changeBgColor(GlobalData.getUiColor(), GlobalData.getUiColor());
        if (GlobalData.getSubmitModel() == SubmitEntryModelEnum.NORMAL) {
            this.showNormalStyle();
        } else if (GlobalData.getSubmitModel() == SubmitEntryModelEnum.WEAK) {
            this.showWeakStyle();
        }
        LinearLayout titleSearch = (LinearLayout)this.showTitleShortSearch(true);
        this.showTitleBack(true);
        this.tabsContentView = (AbsListView)this.findViewById(R.id.css_faqs_list);
        this.loadingView = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.nodataView = (TextView)this.findViewById(R.id.css_recommedfaq_nodata);
        titleSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, FaqListActivity.class));
            }
        });
        this.tabsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (TextUtils.isEmpty((CharSequence)((FaqItem)((FaqActivity)FaqActivity.this).faqs.get((int)position)).id)) {
                    return;
                }
                FaqActivity.this.goToFaqDetail(position);
            }
        });
    }

    private void showNormalStyle() {
        this.qaSubmitBtn.setVisibility(0);
        this.qaHistoryBtn.setVisibility(0);
        this.qaHistoryBtn.setAlertIconVisible(8);
        this.qaHistoryBtn.setImgVisible(8);
        this.showTitleService(false, false, null);
        this.showTitleSystemMsg(true, new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, SystemMsgActivity.class));
            }
        });
        this.qaSubmitBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, FeedBackActivity.class));
            }
        });
        this.qaHistoryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, HistoryActivity.class));
            }
        });
    }

    private void showWeakStyle() {
        this.qaSubmitBtn.setVisibility(8);
        this.qaHistoryBtn.setVisibility(8);
        this.showTitleService(true, false, new AbstractBaseActivity.TitlePopListWindowListener(){

            @Override
            public void onClick(int i) {
                if (i == 0) {
                    FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, FeedBackActivity.class));
                } else if (i == 1) {
                    FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, HistoryActivity.class));
                }
            }
        });
        this.showTitleSystemMsg(true, new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, SystemMsgActivity.class));
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.getNewReply();
        this.getSystemMsg();
    }

    private void getSystemMsg() {
        BusinessRequest.getSystemMsgList(new RequestCallback<ArrayList<SystemMsgEntity>>(){

            @Override
            public void onSuccess(ArrayList<SystemMsgEntity> result) {
                boolean hasUnread = false;
                if (result != null && result.size() > 0) {
                    for (SystemMsgEntity msgEntity : result) {
                        if (!msgEntity.status.equals(Constants.SYSTEM_MSG_UNREAD)) continue;
                        hasUnread = true;
                        break;
                    }
                    if (hasUnread) {
                        FaqActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                FaqActivity.this.showTitleSystemMsgReply(true);
                            }
                        });
                    } else {
                        FaqActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                FaqActivity.this.showTitleSystemMsgReply(false);
                            }
                        });
                    }
                }
            }

            @Override
            public void onFail(String msg, int code) {
            }
        });
    }

    private void getNewReply() {
        BusinessRequest.getExistNewReplyInner(new CSSExistNewReplyCallback(){

            @Override
            public void hasNewReplySuccess(final boolean hasMsg) {
                FaqActivity.this.newSevicesReply = hasMsg;
                FaqActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (GlobalData.getSubmitModel() == SubmitEntryModelEnum.WEAK) {
                            FaqActivity.this.showTitleService(true, hasMsg, new AbstractBaseActivity.TitlePopListWindowListener(){

                                @Override
                                public void onClick(int i) {
                                    if (i == 0) {
                                        FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, FeedBackActivity.class));
                                    } else if (i == 1) {
                                        FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, HistoryActivity.class));
                                    }
                                }
                            });
                        } else if (hasMsg) {
                            FaqActivity.this.qaHistoryBtn.setAlertIconVisible(0);
                        } else {
                            FaqActivity.this.qaHistoryBtn.setAlertIconVisible(8);
                        }
                    }
                });
            }

            @Override
            public void hasNewReplyFail(String msg) {
                FaqActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FaqActivity.this.qaHistoryBtn.setAlertIconVisible(0);
                    }
                });
            }
        });
    }

    @Override
    public void initData() {
        this.faqTypeItems = GlobalData.getTypeItems();
        if (this.faqTypeItems == null || this.faqTypeItems.size() <= 0) {
            this.showError(-100);
            return;
        }
        if (this.isLand) {
            this.initDatainLand();
        } else {
            this.initDatainPort();
        }
        this.requestSystemNotice();
    }

    private void requestSystemNotice() {
        this.showLoadingView();
        BusinessRequest.getSystemNoticeList(new RequestCallback<ArrayList<SystemNoticeItem>>(){

            @Override
            public void onSuccess(final ArrayList<SystemNoticeItem> results) {
                FaqActivity.this.hideLoadingView();
                if (results == null || results.size() <= 0) {
                    return;
                }
                FaqActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        for (SystemNoticeItem result : results) {
                            CommonDialog dialog = new CommonDialog((Context)FaqActivity.this);
                            dialog.setMessage(result.content).setTitle(result.title).setSingle(true).setPositive(FaqActivity.this.getResources().getString(R.string.css_string_got_it)).setPositiveColor(GlobalData.getUiColor());
                            FaqActivity.this.noticeDialogs.put(result.id, dialog);
                        }
                        if (FaqActivity.this.noticeDialogs.size() > 0) {
                            FaqActivity.this.showNoticeDialog();
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqActivity.this.hideLoadingView();
                LogUtils.i("requestSystemNotice onFail is " + msg);
            }
        });
    }

    private void showNoticeDialog() {
        for (Map.Entry<String, CommonDialog> entry : this.noticeDialogs.entrySet()) {
            this.targetId = entry.getKey();
            this.targetDialog = entry.getValue();
        }
        if (this.targetDialog == null) {
            return;
        }
        this.targetDialog.setOnClickBottomListener(new DialogBtnListener(this.targetId));
        this.targetDialog.show((Activity)this);
    }

    private void initDatainPort() {
        this.initTabLayout();
        this.requestFaq(0);
        this.initFaqList();
    }

    private void initFaqList() {
        this.tabsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (TextUtils.isEmpty((CharSequence)((FaqItem)((FaqActivity)FaqActivity.this).faqs.get((int)position)).id)) {
                    return;
                }
                FaqActivity.this.goToFaqDetail(position);
            }
        });
    }

    private void initTabLayout() {
        ArrayList<String> tabs = new ArrayList<String>();
        for (FaqTypeItem item : this.faqTypeItems) {
            tabs.add(item.getFaqTypeByLanguage((Context)this));
        }
        for (String tag : tabs) {
            this.mTab.addTab(this.mTab.newTab().setText((CharSequence)tag));
        }
        this.mTab.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                FaqActivity.this.requestFaq(tab.getPosition());
                if (FaqActivity.this.contentViewAdapter != null) {
                    FaqActivity.this.contentViewAdapter.notifyDataSetChanged();
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
    }

    private void initDatainLand() {
        this.horizonTabAdapter = new HorizonTabAdapter((Context)this, this.faqTypeItems);
        this.verticalTabs.setAdapter((ListAdapter)this.horizonTabAdapter);
        this.requestFaq(0);
        this.verticalTabs.setSelection(0);
        this.verticalTabs.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                FaqActivity.this.horizonTabAdapter.setSelectedId(position);
                FaqActivity.this.horizonTabAdapter.notifyDataSetChanged();
                FaqActivity.this.requestFaq(position);
            }
        });
    }

    private void goToFaqDetail(int position) {
        Intent i = new Intent((Context)this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, this.faqs.get((int)position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, this.faqs.get(position).getFaqTypeByLanguage((Context)this));
        this.startActivity(i);
    }

    @Override
    protected void initExtraData() {
    }

    private void requestFaq(int position) {
        this.showLoadingView();
        this.hideNodataView();
        BusinessRequest.getFaqList(this.faqTypeItems.get(position).getId(), new RequestCallback<List<FaqItem>>(){

            @Override
            public void onSuccess(List<FaqItem> result) {
                FaqActivity.this.hideLoadingView();
                FaqActivity.this.faqs = result;
                FaqActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (FaqActivity.this.faqs == null || FaqActivity.this.faqs.size() <= 0) {
                            FaqActivity.this.tabsContentView.setVisibility(8);
                            return;
                        }
                        FaqActivity.this.tabsContentView.setVisibility(0);
                        FaqActivity.this.faqs.add(new FaqItem());
                        FaqActivity.this.faqs.add(new FaqItem());
                        FaqActivity.this.contentViewAdapter = new SimpleTextGridViewAdapter((Context)FaqActivity.this, FaqActivity.this.faqs);
                        FaqActivity.this.tabsContentView.setAdapter((ListAdapter)FaqActivity.this.contentViewAdapter);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqActivity.this.hideLoadingView();
                FaqActivity.this.showNodataView();
            }
        });
    }

    private void showLoadingView() {
        if (!this.loadingView.isShown()) {
            this.loadingView.setVisibility(0);
        }
    }

    private void hideLoadingView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaqActivity.this.loadingView.isShown()) {
                    FaqActivity.this.loadingView.setVisibility(8);
                }
            }
        });
    }

    private void showNodataView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!FaqActivity.this.nodataView.isShown()) {
                    FaqActivity.this.nodataView.setVisibility(0);
                }
            }
        });
    }

    private void hideNodataView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaqActivity.this.nodataView.isShown()) {
                    FaqActivity.this.nodataView.setVisibility(8);
                }
            }
        });
    }

    class DialogBtnListener
    implements CommonDialog.OnClickBottomListener {
        private String targetId;

        public DialogBtnListener(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public void onPositiveClick() {
            FaqActivity.this.spHelper.putBoolean(this.targetId, true);
            FaqActivity.this.noticeDialogs.remove(this.targetId);
            FaqActivity.this.targetDialog.dismiss();
            if (FaqActivity.this.noticeDialogs.size() == 0) {
                return;
            }
            FaqActivity.this.showNoticeDialog();
        }

        @Override
        public void onNegtiveClick() {
        }
    }
}

