package com.css.sdk.cservice.utils;

import android.view.Gravity;
import android.widget.Toast;

import com.css.sdk.cservice.CServiceSdk;
import com.css.sdk.cservice.base.utils.ThreadHelper;
import com.css.sdk.cservice.userdata.GlobalData;

public class ToastHelper {

    private static Toast toast;//实现不管我们触发多少次Toast调用，都只会持续一次Toast显示的时长

    /**
     * 短时间显示Toast【居下】
     * @param msg 显示的内容-字符串*/
    public static void showShortToast(String msg) {
        ThreadHelper.runOnMainThread(createRunnable4Toast(msg,true,Gravity.CENTER,Toast.LENGTH_SHORT));
    }
    /**
     * 短时间显示Toast【居中】
     * @param msg 显示的内容-字符串*/
    public static void showShortToastCenter(String msg){
        ThreadHelper.runOnMainThread(createRunnable4Toast(msg,false,Gravity.CENTER,Toast.LENGTH_SHORT));

    }

    /**
     * 短时间显示Toast【居上】
     * @param msg 显示的内容-字符串*/
    public static void showShortToastTop(String msg){
        ThreadHelper.runOnMainThread(createRunnable4Toast(msg,false,Gravity.TOP,Toast.LENGTH_SHORT));

    }

    /**
     * 长时间显示Toast【居下】
     * @param msg 显示的内容-字符串*/
    public static void showLongToast(String msg) {
        ThreadHelper.runOnMainThread(createRunnable4Toast(msg,true,Gravity.CENTER,Toast.LENGTH_LONG));
    }
    /**
     * 长时间显示Toast【居中】
     * @param msg 显示的内容-字符串*/
    public static void showLongToastCenter(String msg){
        ThreadHelper.runOnMainThread(createRunnable4Toast(msg,false,Gravity.CENTER,Toast.LENGTH_LONG));
    }
    /**
     * 长时间显示Toast【居上】
     * @param msg 显示的内容-字符串*/
    public static void showLongToastTop(String msg){
        ThreadHelper.runOnMainThread(createRunnable4Toast(msg,false,Gravity.TOP,Toast.LENGTH_LONG));
    }

    /**
     *
     * @param msg
     * @param defaultPosition  是否默认显示位置显示toast，默认是屏幕下方
     * @param gravity          如果defposition是false的话，会按照gravity进行toast位置的显示
     * @param showTime          length_Long 和 short_long
     * @return
     */
    private  static Runnable createRunnable4Toast(String msg,boolean defaultPosition,int gravity,int showTime){
        return new Runnable() {
            @Override
            public void run() {
                if (toast == null) {
                    toast = Toast.makeText(GlobalData.getContext() , msg, showTime);
                    if (!defaultPosition){
                        toast.setGravity(gravity, 0, 0);
                    }
                } else {
                    toast.setText(msg);
                }
                toast.show();
            }
        };
    }
}