package com.css.sdk.cservice.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.view.DisplayCutout;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;

import com.css.sdk.cservice.base.Constants;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class CutoutUtil {
    /**
     * 判断是否是刘海屏
     */
    public static boolean hasNotchScreen(Activity activity) {
        return isAndroidP(activity)||isNotchMi()||hasNotchOppo(activity)||hasNotchHuawei(activity);
    }

    public static void useNotch(Activity activity, int screenType) {
        //9.0
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
            activity.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES;
            activity.getWindow().setAttributes(lp);
            getNotchParams(activity,screenType);
            return;
        }

        //8.0
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            if (RomUtil.isMiui()) {
                int padding = getNotchHeight(activity);
                //针对0037测试机获取刘海宽高为0做的处理，避免刘海遮挡布局
                if (padding > 0) {
                    setDisplayInNotchMi(activity);
                    if(screenType==Constants.SCREEN_TYPE_LAND){
                        activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(padding, 0, 0, 0);
                    }else {
                        activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(0, 0, padding, 0);
                    }

                }
                return;
            }

            if (RomUtil.isOppo()) {
                if(screenType==Constants.SCREEN_TYPE_LAND){
                    activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(getScreenValue(), 0, 0, 0);
                }else {
                    activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(0, 0, 0, 0);
                }
                return;
            }

            if (RomUtil.isVivo()) {
                return;
                //vivo未提供设置到刘海屏的api，竖屏情况设置全屏会自动使用刘海屏，横屏情况无法实现
            }

            if (RomUtil.isEmui()) {
                setFullScreenWindowLayoutInDisplayCutoutHuawei(activity.getWindow());
                if(screenType== Constants.SCREEN_TYPE_LAND){
                    activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(getNotchSize(activity)[1], 0, 0, 0);
                }
                if(screenType== Constants.SCREEN_TYPE_REVERSE_LAND){
                    activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(0, 0, 0, 0);
                }

                return;
            }

        }
    }

    /**
     * 华为 int[0]值为刘海宽度 int[1]值为刘海高度
     */
    private static int[] getNotchSize(Context context) {

        int[] ret = new int[]{0, 0};//int[0]值为刘海宽度 int[1]值为刘海高度

        try {

            ClassLoader cl = context.getClassLoader();

            Class HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");

            Method get = HwNotchSizeUtil.getMethod("getNotchSize");

            ret = (int[]) get.invoke(HwNotchSizeUtil);

        } catch (ClassNotFoundException e) {
        } catch (NoSuchMethodException e) {
        } catch (Exception e) {
        } finally {
            return ret;
        }
    }


    @TargetApi(28)
    private static void getNotchParams(final Activity activity,final int screenType) {
        final View decorView = activity.getWindow().getDecorView();

        decorView.post(new Runnable() {
            @Override
            public void run() {
                WindowInsets insets = decorView.getRootWindowInsets();
                if (insets != null) {
                    DisplayCutout displayCutout = insets.getDisplayCutout();
                    if (displayCutout != null) {
                        List<Rect> rects = displayCutout.getBoundingRects();
                        int pading = 0;
                        if (rects == null || rects.size() == 0) {
                        } else {
                            for (Rect rect : rects) {
                                pading = Math.abs(rect.right - rect.left);
                            }
                        }
                        if (pading != 0) {
                            if(screenType==Constants.SCREEN_TYPE_LAND){
                                activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(pading, 0, 0, 0);
                            }else {
                                activity.getWindow().getDecorView().findViewById(android.R.id.content).setPadding(0, 0, 0, 0);
                            }

                        }
                    }
                }
            }
        });
    }

    /**
     * 判断是否有刘海屏
     *
     * @param context
     * @return true：有刘海屏；false：没有刘海屏
     */
    private static boolean hasNotchHuawei(Context context) {
        boolean ret = false;
        if (RomUtil.isEmui()) {
            try {
                ClassLoader cl = context.getClassLoader();
                Class HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
                Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen");
                ret = (boolean) get.invoke(HwNotchSizeUtil);
            } catch (ClassNotFoundException e) {

            } catch (NoSuchMethodException e) {
            } catch (Exception e) {
            } finally {
                return ret;
            }
        }
        return ret;
    }

    /*刘海屏全屏显示FLAG*/
    private static final int FLAG_NOTCH_SUPPORT = 0x00010000;

    /**
     * 设置应用窗口在华为刘海屏手机使用刘海区
     *
     * @param window 应用页面window对象
     */
    private static void setFullScreenWindowLayoutInDisplayCutoutHuawei(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("addHwFlags", int.class);
            method.invoke(layoutParamsExObj, FLAG_NOTCH_SUPPORT);
        } catch (ClassNotFoundException | NoSuchMethodException | IllegalAccessException | InstantiationException
                | InvocationTargetException e) {
        } catch (Exception e) {
        }
    }

    /**
     * 设置应用窗口在华为刘海屏手机使用刘海区
     *
     * @param window 应用页面window对象
     */
    private static void clearDisplayCutoutHuawei(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("clearHwFlags", int.class);
            method.invoke(layoutParamsExObj, FLAG_NOTCH_SUPPORT);
        } catch (ClassNotFoundException | NoSuchMethodException | IllegalAccessException | InstantiationException
                | InvocationTargetException e) {
        } catch (Exception e) {
        }
    }


    /**
     * oppo全屏会自动使用刘海区域所以需要设置padding值
     */
    private static boolean hasNotchOppo(Activity activity) {
        boolean ret = false;
        if(RomUtil.isOppo()){
            try {
                ret = activity.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
            } catch (Throwable ignore) {
            }
        }
        return ret;
    }

    /**
     * 获取OPPO 刘海的坐标
     * <p>
     * 属性形如：[ro.oppo.screen.heteromorphism]: [378,0:702,80]
     * <p>
     * 获取到的值为378,0:702,80
     * <p>
     * <p>
     * (378,0)是刘海区域左上角的坐标
     * <p>
     * (702,80)是刘海区域右下角的坐标
     */
    private static int getScreenValue() {
        int padding = 0;
        String value = "";
        Class<?> cls;
        try {
            cls = Class.forName("android.os.SystemProperties");
            Method get = cls.getMethod("get", String.class);
            Object object = cls.newInstance();
            value = (String) get.invoke(object, "ro.oppo.screen.heteromorphism");
            if (!TextUtils.isEmpty(value)) {
                if (value.indexOf(":") > -1) {
                    String[] str = value.split(":");
                    if (str.length == 2) {
                        String[] leftP = str[0].split(",");
                        int left = Integer.valueOf(leftP[1]);
                        String[] rightP = str[1].split(",");
                        int right = Integer.valueOf(rightP[1]);
                        padding = Math.abs(right - left);
                    }
                }
            }
        } catch (Throwable ignore) {
        }
        return padding;
    }

    private static boolean isAndroidP(Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        if (decorView != null && android.os.Build.VERSION.SDK_INT >= 28) {
            WindowInsets windowInsets = decorView.getRootWindowInsets();
            if (windowInsets != null && windowInsets.getDisplayCutout() != null)
                return true;
        }
        return false;
    }

    //for 小米 判断是否是刘海屏
    private static boolean isNotchMi() {
        if (RomUtil.isMiui()) {
            try {
                Method getInt = Class.forName("android.os.SystemProperties").getMethod("getInt", String.class, int.class);
                int notch = (int) getInt.invoke(null, "ro.miui.notch", 0);
                return notch == 1;
            } catch (Throwable ignore) {
            }
        }
        return false;
    }

    //for 小米 设置显示到刘海区域
    private static void setDisplayInNotchMi(Activity activity) {
        int flag = 0x00000100 | 0x00000200 | 0x00000400;
        try {
            Method method = Window.class.getMethod("addExtraFlags",
                    int.class);
            method.invoke(activity.getWindow(), flag);
        } catch (Exception ignore) {
        }
    }

    //for mi
    private static int getNotchHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_height", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private static int getNotchWidth(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_width", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private static final int VIVO_NOTCH = 0x00000020; // 是否有刘海
    private static final int VIVO_FILLET = 0x00000008; // 是否有圆角

    /**
     * vivo判断是否有刘海屏
     *
     * @param context
     * @return true：有刘海屏；false：没有刘海屏
     */
    private static boolean hasNotchVivo(Context context) {
        boolean ret = false;
        if (RomUtil.isVivo()) {
            try {
                ClassLoader classLoader = context.getClassLoader();
                Class FtFeature = classLoader.loadClass("android.util.FtFeature");
                Method method = FtFeature.getMethod("isFeatureSupport", int.class);
                ret = (boolean) method.invoke(FtFeature, VIVO_NOTCH);
            } catch (ClassNotFoundException e) {
            } catch (NoSuchMethodException e) {
            } catch (Exception e) {
            } finally {
                return ret;
            }
        }
        return ret;
    }


}
