package com.css.sdk.cservice.base.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.IBinder;
import android.provider.Settings;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;
import android.view.inputmethod.InputMethodManager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Utils {
    public static ArrayList getShuffleList(Collection collection) {
        if (collection == null) {
            return new ArrayList();
        } else {
            ArrayList list = new ArrayList(collection);
            Collections.shuffle(list);
            return list;
        }
    }

    public static int dip2px(Context context, float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }

    /**
     * Api方法转换
     *
     * @param dpValue
     * @return
     */
    public static int dp2px(Context context, float dpValue) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dpValue, context.getResources().getDisplayMetrics());
    }

    public static int getResId(Context context, String type, String name) {
        int id = context.getResources().getIdentifier(name, type, context.getPackageName());
        return id;
    }

    /**
     * 打开浏览器
     */
    public static void openActionView(Context context, String string) {
        Uri uri = Uri.parse(string);
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        context.startActivity(intent);
    }

    /**
     * notification
     */
    public static boolean isNotificationEnable(Context context) {
        if (context == null) {
            return false;
        }
        NotificationManagerCompat manager = NotificationManagerCompat.from(context);
        return manager.areNotificationsEnabled();
    }

    /**
     * open setting
     */
    public static void goToNotification(Context context) {
        if (context == null) {
            return;
        }
        // 根据isOpened结果，判断是否需要提醒用户跳转AppInfo页面，去打开App通知权限
        Intent intent = new Intent();
        intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts("package", context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    public static void hideKeyboard(Context context, IBinder token) {
        if (token != null && context != null) {
            InputMethodManager im = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
            im.hideSoftInputFromWindow(token, InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    public static Drawable getDrawable(Context context, int resid) {
        Drawable mDrawable;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
            mDrawable = ContextCompat.getDrawable(context, resid);
        } else {
            mDrawable = context.getResources().getDrawable(resid);
        }
        return mDrawable;
    }

    public static String readMetaDataFromApplication(Context context, String name) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(),
                    PackageManager.GET_META_DATA);
            String mTag = appInfo.metaData.getString(name);
            return mTag;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
