package com.css.sdk.cservice.base;

import com.css.sdk.R;

public class CSSErrors {

    // 服务端数据json解释时异常
    public static final int CSS_ERROR_RESPONSE_JSON_EXCEPTION = -100;

    // 服务端数据请求时发生的异常，如超时,通讯异常等
    public static final int CSS_ERROR_RESPONSE_HTTP_EXCEPTION = -102;

    // 无网络或者context是空
    public static final int CSS_NO_NETWORK_OR_CONTEXT_NULL = -104;

    // 用户一天内提交工单数目超过15条上限,用户被禁言
    public static final int CSS_REPORT_LIMIT_EXCEPTION =403;

    public static final int CSS_GUEST_VERIFY_PARAMS_MISS_ERROR = 20801;
    public static final int CSS_PRODUCT_DEVICE_VERIFY_PARAM_MISS_ERROR = 20802;
    public static final int CSS_GUEST_MISMATCH_ORDERID = 20803;
    public static final int CSS_QUESTION_TYPE_MISS_ERROR = 20804;
    public static final int CSS_ILLEGAL_QUESTION_TYPE_ERROR = 20805;
    public static final int CSS_ORDERID_PARAM_MISS_ERROR = 20806;
    public static final int CSS_ORDERID_NOT_FOUND_OR_REMOVED_ERROR = 20807;
    public static final int CSS_USER_EVALUATION_PARAM_MISS_ERROR = 20808;
    public static final int CSS_PIC_FILE_EMPTY_ERROR = 20809;
    public static final int CSS_PIC_FILE_TOOLARGE_OR_FORMAT_ERROR = 20810;
    public static final int CSS_PIC_FILE_JSON_FORMAT_ERROR = 20811;
    public static final int CSS_FQA_ID_PARAM_MISS_ERROR = 20812;
    public static final int CSS_FQA_ID_NOT_FOUND_OR_REMOVED_ERROR = 20813;
    public static final int CSS_FQA_EVALUEATION_PARAM_EMPTY_ERROR = 20814;
    public static final int CSS_REPLY_READED = 20815;
    public static final int CSS_ORDERID_PROCESSED = 20816;
    public static final int CSS_ORDERID_CLOSED_OR_REMOVED = 20817;
    public static final int CSS_SYSTEM_ERROR = 10408;


    public static int getErrorMessage(int code) {
        switch (code) {
            case CSS_GUEST_VERIFY_PARAMS_MISS_ERROR:
                return R.string.css_string_guest_verify_param_miss;
            case CSS_PRODUCT_DEVICE_VERIFY_PARAM_MISS_ERROR:
                return R.string.css_string_product_device_verify_param_miss;
            case CSS_GUEST_MISMATCH_ORDERID:
                return R.string.css_string_guest_mismatch_work_order;
            case CSS_QUESTION_TYPE_MISS_ERROR:
                return R.string.css_string_question_type_param_miss;
            case CSS_ILLEGAL_QUESTION_TYPE_ERROR:
                return R.string.css_string_question_type_err;
            case CSS_ORDERID_PARAM_MISS_ERROR:
                return R.string.css_string_workid_param_miss;
            case CSS_ORDERID_NOT_FOUND_OR_REMOVED_ERROR:
                return R.string.css_string_workid_empty_or_removed;
            case CSS_USER_EVALUATION_PARAM_MISS_ERROR:
                return R.string.css_string_user_evaluation_param_miss;
            case CSS_PIC_FILE_EMPTY_ERROR:
                return R.string.css_string_pic_file_empty;
            case CSS_PIC_FILE_TOOLARGE_OR_FORMAT_ERROR:
                return R.string.css_string_pic_size_too_large_or_format_err;
            case CSS_PIC_FILE_JSON_FORMAT_ERROR:
                return R.string.css_string_pics_json_format_err;
            case CSS_FQA_ID_PARAM_MISS_ERROR:
                return R.string.css_string_fqa_id_param_miss;
            case CSS_FQA_ID_NOT_FOUND_OR_REMOVED_ERROR:
                return R.string.css_string_fqa_no_found_or_removed;
            case CSS_FQA_EVALUEATION_PARAM_EMPTY_ERROR:
                return R.string.css_string_fqa_evaluation_param_empty;
            case CSS_SYSTEM_ERROR:
                return R.string.css_string_system_error;
            case CSS_ERROR_RESPONSE_JSON_EXCEPTION:
                return R.string.css_string_response_json_exception;
            case CSS_REPLY_READED:
                return R.string.css_string_reply_readed;
            case CSS_ORDERID_PROCESSED:
                return R.string.css_string_order_has_processed;
            case CSS_ORDERID_CLOSED_OR_REMOVED:
                return R.string.css_string_order_removed_or_closed;
            case CSS_ERROR_RESPONSE_HTTP_EXCEPTION:
                return R.string.css_string_request_exception;
            case CSS_NO_NETWORK_OR_CONTEXT_NULL:
                return R.string.css_string_no_network_or_context_null;
            case CSS_REPORT_LIMIT_EXCEPTION:
                return R.string.css_string_report_limited;
            default:
                return R.string.css_string_unknow_error;
        }
    }

}
