package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.SystemMsgEntity;
import com.css.sdk.cservice.userdata.GlobalData;

import java.util.ArrayList;
import java.util.List;

import static com.css.sdk.cservice.base.Constants.SYSTEM_MSG_READED;
import static com.css.sdk.cservice.base.Constants.SYSTEM_MSG_UNREAD;

/**
 * @ProjectName: customerservicesdk
 * @Package: com.css.sdk.cservice.adapter
 * @ClassName: CssTextGridViewAdapter
 * @Description: CssTextGridViewAdapter
 * @Author: Roy
 * @CreateDate: 2020/5/22 14:46
 */

public class SystemMsgListAdapter extends BaseAdapter {
    private Context mContext;
    private List<SystemMsgEntity> dataList;

    public SystemMsgListAdapter(Context mContext, List<SystemMsgEntity> dataList) {
        this.mContext = mContext;
        this.dataList = dataList;
    }

    @Override
    public int getCount() {
        return dataList == null ? 0 : dataList.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(mContext).inflate(R.layout.css_gridview_history_faq_item, parent, false);
            holder = new ViewHolder();
            holder.root = convertView.findViewById(R.id.css_history_grideview_item_root);
            holder.content = convertView.findViewById(R.id.css_item_content);
            holder.msg = convertView.findViewById(R.id.css_iv_item_history_msg);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        final SystemMsgEntity item = dataList.get(position);
        holder.content.setText(item.title);
        if (item.status.equals(SYSTEM_MSG_UNREAD)) {
            faqNewMessage(holder);
        } else if (item.status.equals(SYSTEM_MSG_READED)) {
            faqReaded(holder);
        }
        return convertView;
    }

    public void setDataList(ArrayList<SystemMsgEntity> msgList) {
        dataList = msgList;
    }


    class ViewHolder {
        RelativeLayout root;
        TextView content;
        ImageView msg;
    }


    private void faqNewMessage(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(GlobalData.getUiAlphaColor());
        viewHolder.msg.setVisibility(View.VISIBLE);
        viewHolder.content.setTextColor(GlobalData.getUiColor());
    }


    private void faqReaded(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(mContext.getResources().getColor(R.color.css_cocor_bg_gray));
        viewHolder.msg.setVisibility(View.GONE);
        viewHolder.content.setTextColor(mContext.getResources().getColor(R.color.css_default_text_dark_gray));
    }

}
