package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.listener.ItemDeleteCallback;
import com.css.sdk.cservice.view.SlideItem;

import java.util.List;

public class HistoryAdapter extends BaseAdapter {
    private List<HistoryItem> dataList;
    private Context context;
    private LayoutInflater inflater;

    public HistoryAdapter(Context context, List<HistoryItem> dataList) {
        this.dataList = dataList;
        this.context = context;
        this.inflater = LayoutInflater.from(context);
    }

    public void bindData(List<HistoryItem> dataList){
        this.dataList = dataList;
    }

    @Override
    public int getCount() {
        return dataList == null ? 0 : dataList.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            View content = inflater.inflate(R.layout.css_history_adapter_item_content, null);
            View menu = inflater.inflate(R.layout.css_history_adapter_item_menu, null);
            holder = new ViewHolder(content, menu);
            SlideItem slideItem = new SlideItem(context);
            slideItem.setContentView(content, menu);
            convertView = slideItem;
            convertView.setTag(holder);
        } else {
            if(convertView instanceof SlideItem){
                SlideItem item = (SlideItem)convertView;
                if(item.isOpen()){
                    item.closeMenu();
                }
            }
            holder = (ViewHolder) convertView.getTag();
        }

        final HistoryItem item = dataList.get(position);
        holder.content.setText(item.title);
        if (item.status.equals(Constants.QA_STATUS_PROCESSED)) {
            holder.newMsg.setVisibility(View.VISIBLE);
            holder.solved.setVisibility(View.GONE);
            holder.content.setTextColor(ContextCompat.getColor(context, R.color.css_color_red));

        } else if (item.status.equals(Constants.QA_STATUS_CLOSED)) {
            holder.solved.setVisibility(View.VISIBLE);
            holder.newMsg.setVisibility(View.GONE);
            holder.content.setTextColor(ContextCompat.getColor(context, R.color.css_color_text_hint));
        } else {
            holder.solved.setVisibility(View.GONE);
            holder.newMsg.setVisibility(View.GONE);
            holder.content.setTextColor(ContextCompat.getColor(context, R.color.css_color_text_content));
        }

        holder.delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(deleteCallback!=null){
                    deleteCallback.onDeleted(String.valueOf(item.id));
                }
            }
        });
        return convertView;
    }

    //新消息动画
    private void starAnim(View view){
    }

    class ViewHolder {
        TextView delete;
        ImageView newMsg;
        TextView solved;
        TextView content;

        public ViewHolder(View center, View menu) {
            this.delete =  menu.findViewById(R.id.css_history_item_delete);
            this.newMsg = center.findViewById(R.id.css_new_msg);
            this.content = center.findViewById(R.id.css_tv_history_content);
            this.solved = center.findViewById(R.id.css_tv_solved);
        }
    }

    private ItemDeleteCallback deleteCallback;

    public void setDeleteCallback(ItemDeleteCallback deleteCallback) {
        this.deleteCallback = deleteCallback;
    }
}
