package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.qmuiteam.qmui.widget.QMUITopBarLayout;
import com.qmuiteam.qmui.widget.dialog.QMUITipDialog;

public class SystemMsgDetailActvity extends AbstractBaseActivity {
    private TextView answerTv;
    private TextView timeTv;
    private SystemMsgDetailEntity detail;
    private String msgTitle = "";
    private String msgId = "";
    QMUITopBarLayout mTopBarLayout;
    // loading
    private QMUITipDialog tipDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        msgId = getIntent().getStringExtra(Constants.KEY_DETAIL_ID);
        msgTitle = getIntent().getStringExtra(Constants.KEY_DETAIL_NAME);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_system_msg_detail_actvity;
    }

    @Override
    public void initView() {
        mTopBarLayout = findViewById(R.id.topbar);
        if (msgTitle.length() >= 60) {
            String substring = msgTitle.substring(0, 60);
            msgTitle = substring + "\n" + msgTitle.substring(60, msgTitle.length());
        }
        answerTv = findViewById(R.id.css_answer);
        timeTv = findViewById(R.id.css_time);
        initTopbar();
    }

    private void initTopbar() {
        mTopBarLayout.addRightImageButton(R.drawable.css_icon_close_small, R.drawable.css_icon_close).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        updateTitle(msgTitle);
    }


    @Override
    public void finish() {
        Intent intent = new Intent();
        intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.SYSTEM_MSG_READED);
        intent.putExtra(Constants.KEY_ORDER_ID, msgId);
        setResult(Constants.SYSTEMMSG_RESULT_CODE, intent);
        super.finish();
    }

    private void updateTitle(String title) {
        if (title != null && !title.equals("")) {
            mTopBarLayout.setTitle(title);
        }
    }

    @Override
    public void initData() {
        requestData();
    }


    private void requestData() {
        showLoading();
        BusinessRequest.getSystemMsgDetail(msgId, new RequestCallback<SystemMsgDetailEntity>() {
            @Override
            public void onSuccess(final SystemMsgDetailEntity result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        detail = result;
                        if (!TextUtils.isEmpty(detail.title)) {
                            answerTv.setText(detail.content);
                            answerTv.setVisibility(View.VISIBLE);
                            timeTv.setText(detail.startTime);
                        } else {
                            timeTv.setVisibility(View.GONE);
                            answerTv.setVisibility(View.GONE);
                        }
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                tipDialog.dismiss();
            }
        });
    }

    private void showLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                tipDialog = new QMUITipDialog.Builder(SystemMsgDetailActvity.this)
                        .setIconType(QMUITipDialog.Builder.ICON_TYPE_LOADING)
                        .setTipWord(getResources().getString(R.string.css_string_loading))
                        .create();
                tipDialog.show();
            }
        });

    }
}
