package com.css.sdk.cservice.activity;

import android.Manifest;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.FullyGridLayoutManager;
import com.css.sdk.cservice.adapter.GridImageAdapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.Picture;
import com.css.sdk.cservice.glide.GlideCacheEngine;
import com.css.sdk.cservice.glide.GlideEngine;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.view.CustomEditText;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureConfig;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnItemClickListener;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.css.sdk.cservice.base.Constants.JSON_PICNAME;
import static com.css.sdk.cservice.base.Constants.JSON_VIDEONAME;


public abstract class FeedBaseActivity extends BaseActivity {
    private static final String TAG = "css_picture";
    public CustomEditText etFeedbackContent;
    private TextView etNumHint;
    public boolean mLoading;
    private LinearLayout loadingLl;
    public TextView loadingTv;

    public RelativeLayout titleBack;
    public TextView titleTv;

    // 用于选中图片上传
    private RecyclerView picRecyView;
    protected GridImageAdapter mSelectedPicsAdapter;
    private int maxSelectNum = 3;

    protected List<Picture> picNames = new ArrayList<>();//上传截图后服务端返回的图片名称；
    protected List<Picture> videoNames = new ArrayList<>();//上传截图后服务端返回的图片名称；
    protected List<Picture> cancelPics = new ArrayList<>();//上传截图后服务端返回的图片名称；

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final int layoutId = getLayoutId();
        if (layoutId > 0) {
            setContentView(layoutId);
        }
        if (savedInstanceState != null) {
            // 被回收
        } else {
            clearCache();
        }
        initView();
        initPicUploadContent(savedInstanceState);
    }

    public abstract int getLayoutId();

    private void initView() {
        RelativeLayout titleRoot = findViewById(R.id.css_title_rl);
        titleRoot.setBackgroundColor(GlobalData.getUiColor());
        titleBack = findViewById(R.id.css_title_back);
        titleTv = findViewById(R.id.css_title_tv);
        etFeedbackContent = findViewById(R.id.css_et_feedback_content);
        etNumHint = findViewById(R.id.css_et_num);
//        etFeedbackContent.setNumTextView(etNumHint);
        loadingLl = findViewById(R.id.css_loading_layout);
        loadingTv = findViewById(R.id.css_loading_tv);
        picRecyView = findViewById(R.id.css_pic_recycler);

        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    private void initPicUploadContent(Bundle savedInstanceState) {

        FullyGridLayoutManager manager = new FullyGridLayoutManager(this,
                4, GridLayoutManager.VERTICAL, false);
        picRecyView.setLayoutManager(manager);
        picRecyView.addItemDecoration(new GridSpacingItemDecoration(4,
                ScreenUtils.dip2px(this, 8), false));
        mSelectedPicsAdapter = new GridImageAdapter(this, onAddPicClickListener);
        mSelectedPicsAdapter.setSelectMax(maxSelectNum);
        if (savedInstanceState != null && savedInstanceState.getParcelableArrayList("selectorList") != null) {
            mSelectedPicsAdapter.setList(savedInstanceState.<LocalMedia>getParcelableArrayList("selectorList"));
        }
        mSelectedPicsAdapter.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(View view, int position) {
                List<LocalMedia> selectList = mSelectedPicsAdapter.getData();
                if (selectList.size() > 0) {
                    LocalMedia media = selectList.get(position);
                    String mimeType = media.getMimeType();
                    int mediaType = PictureMimeType.getMimeType(mimeType);
                    switch (mediaType) {
                        case PictureConfig.TYPE_VIDEO:
                            // 预览视频
                            preViewVideo(media);
                            break;
                        case PictureConfig.TYPE_AUDIO:
                            // 预览音频
                            preViewAudio(media);
                            break;
                        default:
                            // 预览图片
                            preViewPic(position, selectList);
                            break;
                    }
                }
            }
        });
        picRecyView.setAdapter(mSelectedPicsAdapter);
    }

    private void preViewPic(int position, List<LocalMedia> selectList) {
        PictureSelector.create(FeedBaseActivity.this)
                .themeDefStyle()
                .setDefPictureStyle(this)// 动态自定义相册主题
                //.setPictureWindowAnimationStyle(animationStyle)// 自定义页面启动动画
                .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT)// 设置相册Activity方向，不设置默认使用系统
                .isNotPreviewDownload(true)// 预览图片长按是否可以下载
                //.bindCustomPlayVideoCallback(callback)// 自定义播放回调控制，用户可以使用自己的视频播放界面
                .loadImageEngine(GlideEngine.createGlideEngine())// 外部传入图片加载引擎，必传项
                .openExternalPreview(position, selectList);
    }

    private void preViewAudio(LocalMedia media) {
        PictureSelector.create(FeedBaseActivity.this)
                .externalPictureAudio(PictureMimeType.isContent(media.getPath()) ? media.getAndroidQToPath() : media.getPath());
    }

    private void preViewVideo(LocalMedia media) {
        PictureSelector.create(FeedBaseActivity.this)
                .themeDefStyle()
                .setDefPictureStyle(FeedBaseActivity.this)// 动态自定义相册主题
                .externalPictureVideo(TextUtils.isEmpty(media.getAndroidQToPath()) ? media.getPath() : media.getAndroidQToPath());
    }



    public void showLoading() {
        mLoading = true;
        loadingLl.setVisibility(View.VISIBLE);
        loadingTv.setVisibility(View.VISIBLE);
        loadingTv.setText(R.string.css_string_picture_deal);
    }


    public void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!mLoading) return;
                mLoading = false;
                loadingLl.setVisibility(View.GONE);
                loadingTv.setVisibility(View.GONE);
            }
        });

    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (mLoading && keyCode == KeyEvent.KEYCODE_BACK) {
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }

    /**
     * 上传问题截图
     */

    public void upload(final ArrayList<String> pics) {
        LogUtils.i("pics is " + pics.toString());
        showLoading();
        BusinessRequest.uploadPics(pics, new RequestCallback<Map<String, List<Picture>>>() {
            @Override
            public void onSuccess(Map<String, List<Picture>> result) {
                hideLoading();
                videoNames.clear();
                picNames.clear();
                if (result.containsKey(JSON_PICNAME)) {
                    picNames.addAll(result.get(JSON_PICNAME));
                }
                if (result.containsKey(JSON_VIDEONAME)) {
                    videoNames.addAll(result.get(JSON_VIDEONAME));
                }
                StringBuffer sb = new StringBuffer();
                for (Picture picture : picNames) {
                    sb.append(picture.getPicName() + "\n");
                }
                for (Picture picture : videoNames) {
                    sb.append(picture.getPicName() + "\n");
                }
                LogUtils.i("uploadPics result: " + sb.toString());
            }

            @Override
            public void onFail(String msg, int code) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        ToastUtil.showToastTip(getApplicationContext(), CSSErrors.getErrorMessage(code), false);
                        hideLoading();
                    }
                });
            }
        });

    }

    public boolean isContentEmpty() {
        String content = etFeedbackContent.getText().toString().trim();
        if (content.isEmpty()) {
            ToastUtil.showToastTip(getApplicationContext(), R.string.css_string_feedback_content_empty, false);
            return true;
        }
        return false;
    }

    /**
     * 问题反馈成功后清空反馈相关数据
     */
    public void clearData() {
        etFeedbackContent.setText("");
        picNames.clear();
        videoNames.clear();
        cancelPics.clear();
    }

    private void clearCache() {
        // 清空图片缓存，包括裁剪、压缩后的图片 注意:必须要在上传完成后调用 必须要获取权限
        if (PermissionChecker.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
            //PictureFileUtils.deleteCacheDirFile(this, PictureMimeType.ofImage());
            PictureFileUtils.deleteAllCacheDirFile(this);
        } else {
            PermissionChecker.requestPermissions(this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE},
                    PictureConfig.APPLY_STORAGE_PERMISSIONS_CODE);
        }
    }

    private GridImageAdapter.onAddPicClickListener onAddPicClickListener = new GridImageAdapter.onAddPicClickListener() {
        @Override
        public void onAddPicClick() {
            // 进入相册 以下是例子：不需要的api可以不写
            PictureSelector.create(FeedBaseActivity.this)
                    .openGallery(PictureMimeType.ofImage())// 全部.PictureMimeType.ofAll()、图片.ofImage()、视频.ofVideo()、音频.ofAudio()  【关闭视频上传和显示】
                    .loadImageEngine(GlideEngine.createGlideEngine())// 外部传入图片加载引擎，必传项
                    .defTheme()// 主题样式设置 具体参考 values/styles   用法：R.style.picture.white.style v2.3.3后 建议使用setPictureStyle()动态方式
//                        .isUseCustomCamera(cb_custom_camera.isChecked())// 是否使用自定义相机
//                    .setLanguage(LanguageConfig.ENGLISH)// 设置语言，默认英文
                    .setDefPictureStyle(FeedBaseActivity.this)// 动态自定义相册主题
//                    .isWithVideoImage(true)// 图片和视频是否可以同选,只在ofAll模式下有效  【关闭视频上传和显示】
                    .loadCacheResourcesCallback(GlideCacheEngine.createCacheEngine())// 获取图片资源缓存，主要是解决华为10部分机型在拷贝文件过多时会出现卡的问题，这里可以判断只在会出现一直转圈问题机型上使用
                    //.setOutputCameraPath()// 自定义相机输出目录，只针对Android Q以下，例如 Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM) +  File.separator + "Camera" + File.separator;
                    //.setButtonFeatures(CustomCameraView.BUTTON_STATE_BOTH)// 设置自定义相机按钮状态
                    .maxSelectNum(maxSelectNum)// 最大图片选择数量
                    .minSelectNum(0)// 最小选择数量
//                    .videoMaxSize(10) //视频允许的大小(mb) 【关闭视频上传和显示】
                    .maxVideoSelectNum(0) // 视频最大选择数量，如果没有单独设置的需求则可以不设置，同用maxSelectNum字段  【关闭视频上传和显示】
                    //.minVideoSelectNum(1)// 视频最小选择数量，如果没有单独设置的需求则可以不设置，同用minSelectNum字段
                    .imageSpanCount(4)// 每行显示个数
                    .isReturnEmpty(false)// 未选择数据时点击按钮是否可以返回
                    //.isAndroidQTransform(false)// 是否需要处理Android Q 拷贝至应用沙盒的操作，只针对compress(false); && enableCrop(false);有效,默认处理
                    .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT)// 设置相册Activity方向，不设置默认使用系统
                    .isOriginalImageControl(false)// 是否显示原图控制按钮，如果设置为true则用户可以自由选择是否使用原图，压缩、裁剪功能将会失效
                    //.bindCustomPlayVideoCallback(callback)// 自定义视频播放回调控制，用户可以使用自己的视频播放界面
                    //.bindPictureSelectorInterfaceListener(interfaceListener)// 提供给用户的一些额外的自定义操作回调
                    //.cameraFileName(System.currentTimeMillis() +".jpg")    // 重命名拍照文件名、如果是相册拍照则内部会自动拼上当前时间戳防止重复，注意这个只在使用相机时可以使用，如果使用相机又开启了压缩或裁剪 需要配合压缩和裁剪文件名api
                    //.renameCompressFile(System.currentTimeMillis() +".jpg")// 重命名压缩文件名、 注意这个不要重复，只适用于单张图压缩使用
                    //.renameCropFileName(System.currentTimeMillis() + ".jpg")// 重命名裁剪文件名、 注意这个不要重复，只适用于单张图裁剪使用
                    .selectionMode(PictureConfig.MULTIPLE)// 多选 or 单选
                    .previewImage(true)// 是否可预览图片
                    .previewVideo(false)// 是否可预览视频 【关闭视频上传和显示】
                    //.querySpecifiedFormatSuffix(PictureMimeType.ofJPEG())// 查询指定后缀格式资源
                    .enablePreviewAudio(false) // 是否可播放音频频 【关闭视频上传和显示】
                    .isCamera(false)// 是否显示拍照按钮
                    //.isMultipleSkipCrop(false)// 多图裁剪时是否支持跳过，默认支持
                    //.isMultipleRecyclerAnimation(false)// 多图裁剪底部列表显示动画效果
                    .isZoomAnim(true)// 图片列表点击 缩放效果 默认true
                    //.imageFormat(PictureMimeType.PNG)// 拍照保存图片格式后缀,默认jpeg
                    .enableCrop(false)// 是否裁剪
                    //.basicUCropConfig()//对外提供所有UCropOptions参数配制，但如果PictureSelector原本支持设置的还是会使用原有的设置
                    .compress(true)// 是否压缩
                    //.compressQuality(80)// 图片压缩后输出质量 0~ 100
                    .synOrAsy(true)//同步true或异步false 压缩 默认同步
                    //.queryMaxFileSize(10)// 只查多少M以内的图片、视频、音频  单位M
                    //.compressSavePath(getPath())//压缩图片保存地址
                    //.sizeMultiplier(0.5f)// glide 加载图片大小 0~1之间 如设置 .glideOverride()无效 注：已废弃
                    //.glideOverride(160, 160)// glide 加载宽高，越小图片列表越流畅，但会影响列表图片浏览的清晰度 注：已废弃
                    .isGif(false)// 是否显示gif图片
                    //.setCircleDimmedColor(ContextCompat.getColor(getContext(), R.color.app_color_white))// 设置圆形裁剪背景色值
                    //.setCircleDimmedBorderColor(ContextCompat.getColor(getApplicationContext(), R.color.app_color_white))// 设置圆形裁剪边框色值
                    //.setCircleStrokeWidth(3)// 设置圆形裁剪边框粗细
                    .openClickSound(false)// 是否开启点击声音
                    .selectionMedia(mSelectedPicsAdapter.getData())// 是否传入已选图片
                    //.isDragFrame(false)// 是否可拖动裁剪框(固定)
                    .videoMinSecond(2)
                    .videoMaxSecond(30)
                    //.recordVideoSecond(10)//录制视频秒数 默认60s
                    //.previewEggs(false)// 预览图片时 是否增强左右滑动图片体验(图片滑动一半即可看到上一张是否选中)
                    .cutOutQuality(90)// 裁剪输出质量 默认100
                    .minimumCompressSize(100)// 小于100kb的图片不压缩
                    //.videoQuality()// 视频录制质量 0 or 1
                    //.videoSecond()//显示多少秒以内的视频or音频也可适用
                    //.forResult(PictureConfig.CHOOSE_REQUEST);//结果回调onActivityResult code
                    .forResult(new OnResultCallbackListener<LocalMedia>() {
                        @Override
                        public void onResult(List<LocalMedia> result) {
                            ArrayList<String> pics = new ArrayList<>();
                            for (LocalMedia media : result) {
                                showLog2pictureSelector(false,media);
                                if (PictureMimeType.eqVideo(media.getMimeType())) {
                                    if (media.getPath().endsWith(".mp4")) {
                                        pics.add(media.getPath());
                                    }
                                } else if (PictureMimeType.eqImage(media.getMimeType())) {
                                    // 判断是不是.0结尾的
                                    if (media.getCompressPath().endsWith(".0")) {
                                        String newPath = media.getCompressPath().substring(0, media.getCompressPath().length() - 2) + ".jpeg";
                                        // 修改名称
                                        File errorFile = new File(media.getCompressPath());
                                        if (errorFile.exists()) {
                                            File newFile = new File(newPath);
                                            errorFile.renameTo(newFile);
                                            media.setCompressPath(newPath);
                                        }
                                    }
                                    pics.add(media.getCompressPath());
                                }
                            }
                            upload(pics);
                            mSelectedPicsAdapter.setList(result);
                            mSelectedPicsAdapter.notifyDataSetChanged();
                        }

                        @Override
                        public void onCancel() {
                            Log.i(TAG, "PictureSelector Cancel");
                        }
                    });
        }
    };

    private void showLog2pictureSelector(boolean b, LocalMedia media) {
        if (!b) {
            return;
        }
        LogUtils.i("是否压缩:" + media.isCompressed());
        LogUtils.i("压缩:" + media.getCompressPath());
        LogUtils.i("原图:" + media.getPath());
        LogUtils.i("是否裁剪:" + media.isCut());
        LogUtils.i("裁剪:" + media.getCutPath());
        LogUtils.i("是否开启原图:" + media.isOriginal());
        LogUtils.i("原图路径:" + media.getOriginalPath());
        LogUtils.i("Android Q 特有Path:" + media.getAndroidQToPath());
        LogUtils.i("宽高: " + media.getWidth() + "x" + media.getHeight());
        LogUtils.i("Size: " + media.getSize());
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (mSelectedPicsAdapter != null && mSelectedPicsAdapter.getData() != null && mSelectedPicsAdapter.getData().size() > 0) {
            outState.putParcelableArrayList("selectorList",
                    (ArrayList<? extends Parcelable>) mSelectedPicsAdapter.getData());
        }
    }
}
