package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.ChatAdapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.Chat;
import com.css.sdk.cservice.data.OrderDetail;
import com.css.sdk.cservice.data.Picture;
import com.css.sdk.cservice.glide.GlideCacheEngine;
import com.css.sdk.cservice.glide.GlideEngine;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.ToastHelper;
import com.css.sdk.cservice.view.CssRoundBtn;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureConfig;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import com.luck.picture.lib.tools.ScreenUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static com.css.sdk.cservice.base.Constants.JSON_PICNAME;
import static com.css.sdk.cservice.base.Constants.JSON_VIDEONAME;

public class ChatDetailActivity extends AbstractBaseActivity {
    private long id;//工单id
    private boolean isUnread;
    private OrderDetail detail;
    private LinearLayout bottomLl;
    private TextView bottomHintTv;

    private CssRoundBtn leftBtnRoot;
    private CssRoundBtn rightBtnRoot;


    private ListView chatListview;
    private RelativeLayout appendQuestionRl;
    //    private TextView appendQuestionTv;
    private RelativeLayout chatContainerLl;
    private String selectedQaType;
    //    private ImageView appendCloseIv;
    private ChatAdapter chatAdapter;
    private boolean hasClosed;
    private boolean hasReaded;
    private boolean hasChecked;//是否检测了问题类型的高度
    private LinearLayout loadingView;

    // 继续追问

    private ImageView addPicsBtn;
    private TextView sendAppendQaBtn;
    private List<LocalMedia> selectedPics = new ArrayList<>();
    private List<Picture> picNames = new ArrayList<>();//上传截图后服务端返回的图片名称；
    private List<Picture> videoNames = new ArrayList<>();//上传截图后服务端返回的图片名称；
    private EditText appendQaContent;
    // 是否显示了追问
    private boolean isShowAppenedQa;



    private Handler handler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            int what = msg.what;
            switch (what) {
                case 1:
                    /**
                     * ListView条目控制在最后一行
                     */
                    if (chatAdapter.getCount() > 0) {
                        chatListview.setSelection(chatAdapter.getCount());
                    }
                    clearData();
                    break;

                default:
                    break;
            }
        }
    };

    private void clearData() {
        appendQaContent.setText("");
        picNames.clear();
        videoNames.clear();
    }


    @Override
    protected void initExtraData() {
        id = getIntent().getLongExtra(Constants.KEY_DETAIL_ID, 0);
        isUnread = getIntent().getBooleanExtra(Constants.KEY_IS_UNREAD, false);

    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_chatdetail;
    }

    @Override
    public void initView() {
        super.initView();
        loadingView = findViewById(R.id.css_loading_layout);
        chatContainerLl = findViewById(R.id.css_detail_container);
        bottomLl = findViewById(R.id.css_question_detail_bottom_ll);
        bottomHintTv = findViewById(R.id.css_question_detail_hint);
        leftBtnRoot = findViewById(R.id.css_question_detail_left_btn);
        appendQuestionRl = findViewById(R.id.append_question_rl);
        appendQuestionRl.setVisibility(View.GONE);
        appendQuestionRl.setBackgroundColor(GlobalData.getUiColor());
        rightBtnRoot = findViewById(R.id.css_question_detail_right_btn);
        leftBtnRoot.changeBgColor(GlobalData.getUiColor(),GlobalData.getUiColor());
        leftBtnRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                leftClick();
            }
        });
        chatListview = findViewById(R.id.css_question_chat_listview);

        rightBtnRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                rightClick();
            }
        });

        addPicsBtn = findViewById(R.id.css_detail_add_pics);
        addPicsBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openGallery();
            }
        });
        appendQaContent = findViewById(R.id.css_detial_appendqa_content);
        sendAppendQaBtn = findViewById(R.id.css_detail_appendqa_send);
        sendAppendQaBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                feedBack();
            }
        });
        showTitleBack(true);
    }


    @Override
    public void initData() {
        requestData();
    }


    private void feedBack() {
        if (TextUtils.isEmpty(appendQaContent.getText().toString().trim())) {
            return;
        }
        showLoading();
        final String content = appendQaContent.getText().toString().trim();
        BusinessRequest.feedBackN(this, String.valueOf(id), picNames, videoNames, new ArrayList<>(), -1, selectedQaType, content, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        Chat chat = new Chat();
                        chat.send = "ask";
                        chat.original = content;
                        selectedPics.clear();
                        ArrayList<String> selected = new ArrayList<>();
                        for (Picture file : picNames) {
                            selected.add(file.getPicName());
                        }
                        chat.pics = selected;
                        closeAppend();
                        appendQuestion(chat);
                        checkSpHelper();
//                        spHelper.putString(Constants.LAST_QA_TYPE, selectedQaType);

                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void closeAppend() {
        hideSoftKeyboard();
        appendQuestionRl.startAnimation(AnimationUtils.loadAnimation(ChatDetailActivity.this, R.anim.css_exit_top_to_bottom));
        appendQuestionRl.setVisibility(View.GONE);
        bottomLl.setVisibility(View.VISIBLE);
    }

    @Override
    public void showTitleBack(boolean show) {
        RelativeLayout titleBack = findViewById(R.id.css_title_back);
        titleBack.setVisibility(show ? View.VISIBLE : View.GONE);
        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (appendQuestionRl.isShown()) {
                    closeAppend();
                    return;
                }
                finish();
            }
        });
    }

//    @Override
//    public void onBackPressed() {
//        LogUtils.i("onBackPressed");
//        if (appendQuestionRl.getVisibility()==View.VISIBLE){
//            LogUtils.i("(appendQuestionRl.isShown()");
//            appendQuestionRl.setVisibility(View.GONE);
//            bottomLl.setVisibility(View.VISIBLE);
//        }else{
//            super.onBackPressed();
//        }
//    }

    private void leftClick() {
        if (detail.status.equals(Constants.QA_STATUS_CLOSED) && (!detail.evaluated)) {
            evaluate(false);
        } else {
            showAppenQuestView();
        }
    }

    private void showAppenQuestView() {
        appendQuestionRl.startAnimation(AnimationUtils.loadAnimation(ChatDetailActivity.this, R.anim.css_enter_bottom_to_up));
        appendQuestionRl.setVisibility(View.VISIBLE);
        isShowAppenedQa=true;
        if (!hasChecked) {
            hasChecked = true;
//                dealTypeTvHeight();
        }
    }

    private void evaluate(boolean isGood) {
        showLoading();
        BusinessRequest.evaluateWorkOrder(String.valueOf(id), isGood, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        detail.status = Constants.QA_STATUS_CLOSED;
                        detail.evaluated = true;
                        dealBottomRl(detail.status);
                        ToastHelper.showShortToastCenter(getResources().getString(R.string.css_string_thanks_for_evaluate));
                        finish();
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void showLoading() {
        loadingView.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                    loadingView.setVisibility(View.GONE);
            }
        });
    }

    private void commitFinish() {
        showLoading();
        BusinessRequest.fqaFinish(String.valueOf(id), new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        hasClosed = true;
                        detail.status = Constants.QA_STATUS_CLOSED;
                        detail.evaluated = false;
                        dealBottomRl(detail.status);
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (appendQuestionRl.getVisibility() == View.VISIBLE && keyCode == KeyEvent.KEYCODE_BACK) {
            appendQuestionRl.setVisibility(View.GONE);
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }

    private void rightClick() {
        if ((detail.status.equals(Constants.QA_STATUS_CLOSED) || detail.status.equals(Constants.QA_STATUS_CLOSED_TIMEOUT)) && !detail.evaluated) {
            evaluate(true);
        } else {
            commitFinish();

        }
    }

    private void dealBottomRl(String status) {
        leftBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blue);
        rightBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blueline);
        if (status.equals(Constants.QA_STATUS_WAITING)
                || status.equals(Constants.QA_STATUS_WAITING_APPEND)
                || status.equals(Constants.QA_STATUS_PROCESSING) || status.equals(Constants.QA_STATUS_PROCESSED) || status.equals(Constants.QA_STATUS_PROCESSED_READ)) {
            bottomLl.setVisibility(View.VISIBLE);
            bottomHintTv.setVisibility(View.GONE);
            leftBtnRoot.setVisibility(View.VISIBLE);
            setDrawable(true, R.drawable.css_icon_edit_white,Color.WHITE,GlobalData.getUiColor(),GlobalData.getUiColor(), R.string.css_string_append_question);
            rightBtnRoot.setVisibility(View.VISIBLE);
            setDrawable(false, R.drawable.css_icon_success,GlobalData.getUiColor(), Color.WHITE,GlobalData.getUiColor(),R.string.css_string_question_solved_text);
        } else if (status.equals(Constants.QA_STATUS_CLOSED) || status.equals(Constants.QA_STATUS_CLOSED_TIMEOUT)) {
            if (detail.evaluated) {
                bottomLl.setVisibility(View.GONE);
//                ToastHelper.showShortToastCenter(getResources().getString(R.string.css_string_thanks_for_evaluate));
//                finish();
//                bottomHintTv.setVisibility(View.VISIBLE);
//                bottomHintTv.setText(R.string.css_string_question_solved_hint);
//
//                leftBtnRoot.setVisibility(View.GONE);
//                rightBtnRoot.setVisibility(View.VISIBLE);
//                setDrawable(false, R.drawable.css_icon_edit_blue, R.string.css_string_feedback_new);
            } else {
                leftBtnRoot.setVisibility(View.VISIBLE);
                rightBtnRoot.setVisibility(View.VISIBLE);
                leftBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blueline);
                rightBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blue);
                bottomLl.setVisibility(View.VISIBLE);
                bottomHintTv.setVisibility(View.VISIBLE);
                bottomHintTv.setText(R.string.css_string_wait_comment_hint);
                bottomHintTv.setTextColor(GlobalData.getUiColor());
                setDrawable(true, R.drawable.css_icon_bad_gray, GlobalData.getUiColor(),Color.WHITE,GlobalData.getUiColor(),R.string.css_string_satisfy_no);
                setDrawable(false, R.drawable.css_icon_good_gray,Color.WHITE,GlobalData.getUiColor(),GlobalData.getUiColor(), R.string.css_string_satisfy_yes);
            }
        }
    }

    /**
     * 屏幕适配
     */
    private void setDrawable(boolean isLeft, final int resId,final int textColor, final int bgColor, final int strokeColor,int stringId) {
        String text = getString(stringId);
        if (isLeft) {
            leftBtnRoot.setText(text);
            leftBtnRoot.setImgVisible(View.VISIBLE);
            leftBtnRoot.changeImg(getResources().getDrawable(resId));
            leftBtnRoot.changeTextColor(textColor);
            leftBtnRoot.changeBgColor(bgColor,strokeColor);
        } else {
            rightBtnRoot.setText(text);
            rightBtnRoot.setImgVisible(View.VISIBLE);
            rightBtnRoot.changeImg(getResources().getDrawable(resId));
            rightBtnRoot.changeBgColor(bgColor,strokeColor);
            rightBtnRoot.changeTextColor(textColor);
        }
//        rightBtnTv.post(new Runnable() {
//            @Override
//            public void run() {
//                int right = rightBtnTv.getLineCount();
//                int left = leftBtnTv.getLineCount();
//                if (right > 1 || left > 1) {
//                    rightBtnIv.setVisibility(View.GONE);
//                    leftBtnIv.setVisibility(View.GONE);
//                }
//            }
//        });

    }

    //追加问题
    private void appendQuestion(Chat chat) {

        detail.chats.add(chat);
//        // 为了不遮挡最后的两个按钮，追加一个item
//        detail.chats.add(new Chat("holder"));

        chatAdapter.bindData(detail);
        chatAdapter.notifyDataSetChanged();
        handler.sendEmptyMessage(1);
    }

    private void requestData() {
        showLoading();
        BusinessRequest.getDetail(id, new RequestCallback<OrderDetail>() {
            @Override
            public void onSuccess(final OrderDetail result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        chatContainerLl.setVisibility(View.VISIBLE);
                        hideLoading();
                        detail = result;
                        selectedQaType = detail.type;
                        if (isUnread) {
                            hasReaded = true;
                        }
                        dealBottomRl(detail.status);
                        chatAdapter = new ChatAdapter(ChatDetailActivity.this, detail);
                        chatListview.setAdapter(chatAdapter);
                        handler.sendEmptyMessage(1);
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }


    @Override
    public void finish() {
        if (hasClosed || hasReaded) {
            Intent intent = new Intent();
            if (hasReaded) {
                intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.ORDER_CHANGE_TO_READED);
            }
            if (hasClosed) {
                intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.ORDER_CHANGE_TO_CLOSED);
            }

            intent.putExtra(Constants.KEY_ORDER_ID, id);
            setResult(Constants.HISTORY_RESULT_CODE, intent);
        }
        super.finish();
    }


    private void openGallery() {
        // 进入相册 以下是例子：不需要的api可以不写
        PictureSelector.create(this)
                .openGallery(PictureMimeType.ofImage())// 全部.PictureMimeType.ofAll()、图片.ofImage()、视频.ofVideo()、音频.ofAudio()  【关闭视频上传和显示】
                .loadImageEngine(GlideEngine.createGlideEngine())// 外部传入图片加载引擎，必传项
                .defTheme()// 主题样式设置 具体参考 values/styles   用法：R.style.picture.white.style v2.3.3后 建议使用setPictureStyle()动态方式
                .setDefPictureStyle(this)// 动态自定义相册主题
                .loadCacheResourcesCallback(GlideCacheEngine.createCacheEngine())// 获取图片资源缓存，主要是解决华为10部分机型在拷贝文件过多时会出现卡的问题，这里可以判断只在会出现一直转圈问题机型上使用
                .maxSelectNum(3)// 最大图片选择数量
                .minSelectNum(0)// 最小选择数量
//                    .videoMaxSize(10) //视频允许的大小(mb) 【关闭视频上传和显示】
                .maxVideoSelectNum(0) // 视频最大选择数量，如果没有单独设置的需求则可以不设置，同用maxSelectNum字段  【关闭视频上传和显示】
                .imageSpanCount(4)// 每行显示个数
                .isReturnEmpty(false)// 未选择数据时点击按钮是否可以返回
                .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT)// 设置相册Activity方向，不设置默认使用系统
                .isOriginalImageControl(false)// 是否显示原图控制按钮，如果设置为true则用户可以自由选择是否使用原图，压缩、裁剪功能将会失效
                .selectionMode(PictureConfig.MULTIPLE)// 多选 or 单选
                .previewImage(true)// 是否可预览图片
                .previewVideo(false)// 是否可预览视频 【关闭视频上传和显示】
                .enablePreviewAudio(false) // 是否可播放音频频 【关闭视频上传和显示】
                .isCamera(false)// 是否显示拍照按钮
                .isZoomAnim(true)// 图片列表点击 缩放效果 默认truex
                .enableCrop(false)// 是否裁剪
                .compress(true)// 是否压缩
                .synOrAsy(true)//同步true或异步false 压缩 默认同步
                .isGif(false)// 是否显示gif图片
                .openClickSound(false)// 是否开启点击声音
                .selectionMedia(selectedPics)// 是否传入已选图片
                //.isDragFrame(false)// 是否可拖动裁剪框(固定)
                .videoMinSecond(2)
                .videoMaxSecond(30)
                .cutOutQuality(90)// 裁剪输出质量 默认100
                .minimumCompressSize(100)// 小于100kb的图片不压缩
                .forResult(new OnResultCallbackListener<LocalMedia>() {
                    @Override
                    public void onResult(List<LocalMedia> result) {
                        ArrayList<String> pics = new ArrayList<>();
                        for (LocalMedia media : result) {
                            if (PictureMimeType.eqVideo(media.getMimeType())) {
                                if (media.getPath().endsWith(".mp4")) {
                                    pics.add(media.getPath());
                                }
                            } else if (PictureMimeType.eqImage(media.getMimeType())) {
                                // 判断是不是.0结尾的
                                if (media.getCompressPath().endsWith(".0")) {
                                    String newPath = media.getCompressPath().substring(0, media.getCompressPath().length() - 2) + ".jpeg";
                                    // 修改名称
                                    File errorFile = new File(media.getCompressPath());
                                    if (errorFile.exists()) {
                                        File newFile = new File(newPath);
                                        errorFile.renameTo(newFile);
                                        media.setCompressPath(newPath);
                                    }
                                }
                                pics.add(media.getCompressPath());
                            }
                        }
                        upload(pics);
                        selectedPics = result;
                    }

                    @Override
                    public void onCancel() {
                        LogUtils.i("PictureSelector Cancel");
                    }
                });
    }

    /**
     * 上传问题截图
     */

    public void upload(final ArrayList<String> pics) {
        LogUtils.i("pics is " + pics.toString());
        showLoading();
        BusinessRequest.uploadPics(pics, new RequestCallback<Map<String, List<Picture>>>() {
            @Override
            public void onSuccess(Map<String, List<Picture>> result) {
                hideLoading();
                if (result.containsKey(JSON_PICNAME)) {
                    picNames.addAll(result.get(JSON_PICNAME));
                }
                if (result.containsKey(JSON_VIDEONAME)) {
                    videoNames.addAll(result.get(JSON_VIDEONAME));
                }
                StringBuffer sb = new StringBuffer();
                for (Picture picture : picNames) {
                    sb.append(picture.getPicName() + "\n");
                }
                for (Picture picture : videoNames) {
                    sb.append(picture.getPicName() + "\n");
                }
//                selectedPics.clear();
                LogUtils.i("uploadPics result: " + sb.toString());
            }

            @Override
            public void onFail(String msg, int code) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        ToastUtil.showToastTip(getApplicationContext(), CSSErrors.getErrorMessage(code), false);
                        hideLoading();
                    }
                });
            }
        });

    }
}
