package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v7.app.ActionBar;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.PopupListAdapter;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.data.ImageFloder;
import com.css.sdk.cservice.data.PopWindowEntity;
import com.css.sdk.cservice.userdata.GlobalData;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.popup.QMUIListPopup;
import com.qmuiteam.qmui.widget.popup.QMUIPopup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static com.css.sdk.cservice.base.Constants.SYSTEM_MSG_READED;
import static com.css.sdk.cservice.base.Constants.SYSTEM_MSG_UNREAD;

public abstract class AbstractBaseActivity extends BaseActivity {

    protected abstract void initExtraData();

    public abstract int getLayoutId();

    public void initView(){
        changeTitleColor(GlobalData.getUiColor());
    };

    public abstract void initData();

    private QMUIListPopup mListPopup;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // 去掉窗口标题
//        requestWindowFeature(Window.FEATURE_NO_TITLE);
//        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        initExtraData();
        setContentView(getLayoutId());
        initView();
        initData();
    }

    /**
     * 显示左边的返回按钮，默认是finish当前activity，需要的话可以重写
     *
     * @param show
     */
    public void showTitleBack(boolean show) {
        RelativeLayout titleBack = findViewById(R.id.css_title_back);
        titleBack.setVisibility(show ? View.VISIBLE : View.GONE);
        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    public void changeTitleColor(int rgb) {
        RelativeLayout titleRoot = findViewById(R.id.css_title_rl);
        titleRoot.setBackgroundColor(rgb);
    }


    protected void showTitleClose(boolean show) {
        RelativeLayout closeRoot = findViewById(R.id.css_title_close);
        closeRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        closeRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }


    protected void showTitleName(boolean show, String name) {
        RelativeLayout titleTvRoot = findViewById(R.id.rl_titile_text);
        titleTvRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        if (!show) {
            return;
        }
        TextView titleTv = findViewById(R.id.css_title_tv);
        titleTv.setText(name);
    }


    protected void showTitleName(boolean show, String name, int color) {
        RelativeLayout titleTvRoot = findViewById(R.id.rl_titile_text);
        titleTvRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        if (!show) {
            return;
        }
        TextView titleTv = findViewById(R.id.css_title_tv);
        titleTv.setText(name);
        titleTv.setTextColor(color);
    }

    protected void showTitleLargeSearch(boolean show) {
        LinearLayout largeSeachRoot = findViewById(R.id.rl_title_largesearch);
        largeSeachRoot.setVisibility(show ? View.VISIBLE : View.GONE);
    }

    protected View showTitleShortSearch(boolean show) {
        LinearLayout searchRoot = findViewById(R.id.rl_title_shortsearch);
        searchRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        return searchRoot;
    }

    protected void showTitleTab(boolean show, List<String> tags, TabLayout.BaseOnTabSelectedListener listener) {
        RelativeLayout tabLayout = findViewById(R.id.rl_titile_tab);
        tabLayout.setVisibility(show ? View.VISIBLE : View.GONE);
        if (!show) {
            return;
        }

        TabLayout mTabLayout = findViewById(R.id.css_title_tab_layout);
        // 添加 tab item
        for (String tag : tags) {
            mTabLayout.addTab(mTabLayout.newTab().setText(tag));
        }
        mTabLayout.addOnTabSelectedListener(listener);
    }

    protected void goActvityForResult(Context clz, Class targetClz, int requestCode) {
        Intent intent = new Intent(clz, targetClz);
        startActivityForResult(intent, requestCode);
    }

    protected void showTitleService(boolean show,boolean hasHistroyNotice, TitlePopListWindowListener listener) {
        RelativeLayout serviceRoot = findViewById(R.id.css_title_service);
        serviceRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        ImageView alertIv=findViewById(R.id.css_title_service_reply);
        if (hasHistroyNotice){
            alertIv.setVisibility(View.VISIBLE);
        }else{
            alertIv.setVisibility(View.GONE);
        }
        if (listener != null) {
            initListPopupIfNeed(hasHistroyNotice,listener);
        } else {
            return;
        }
        //显示listpopwindow
        serviceRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListPopup.setAnimStyle(QMUIPopup.ANIM_GROW_FROM_CENTER);
                mListPopup.setPreferredDirection(QMUIPopup.DIRECTION_BOTTOM);
                mListPopup.show(serviceRoot);
            }
        });

//        btnShowPop.setText("show pop list");

    }

    protected void showTitleServiceReply(boolean show) {
        ImageView serviceReply = findViewById(R.id.css_title_service_reply);
        serviceReply.setVisibility(show ? View.VISIBLE : View.GONE);
        // poplist中history中status也会是READ
    }

    protected void showTitleSystemMsg(boolean show, View.OnClickListener listener) {
        RelativeLayout systemMsgRoot = findViewById(R.id.css_title_system_msg);
        systemMsgRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        if (listener != null) {
            systemMsgRoot.setOnClickListener(listener);
        } else {
            return;
        }
    }

    protected void showTitleSystemMsgReply(boolean show) {
        ImageView msgReply = findViewById(R.id.css_title_system_msg_reply);
        msgReply.setVisibility(show ? View.VISIBLE : View.GONE);
    }

    /**
     * dp转px
     */
    protected int dp2px(Context context, float dpValue) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dpValue, context.getResources().getDisplayMetrics());
    }

    protected Point getScreenMsg(Context context) {
        Point point = new Point();
        WindowManager wm = (WindowManager) context
                .getSystemService(Context.WINDOW_SERVICE);
        wm.getDefaultDisplay().getSize(point);
        return point;
    }


    private void initListPopupIfNeed(boolean showHistoryNotice, TitlePopListWindowListener listener) {
        PopWindowEntity feedback = new PopWindowEntity(R.drawable.css_icon_edit_blue, getResources().getString(R.string.css_text_submit_qa));
        feedback.status = SYSTEM_MSG_READED;
        PopWindowEntity history = new PopWindowEntity(R.drawable.css_icon_viewlist, getResources().getString(R.string.css_string_feedback_history));
        if (showHistoryNotice) {
            history.status=SYSTEM_MSG_UNREAD;
        }else{
            history.status=SYSTEM_MSG_READED;
        }
        List<PopWindowEntity> data = new ArrayList<>();
        data.add(feedback);
        data.add(history);
        PopupListAdapter popupListAdapter = new PopupListAdapter(this, data);
//            ArrayAdapter adapter = new ArrayAdapter<>(this, R.layout.css_simple_list_item, data);
        mListPopup = new QMUIListPopup(this, QMUIPopup.DIRECTION_NONE, popupListAdapter);
        mListPopup.create(QMUIDisplayHelper.dp2px(this, 100), QMUIDisplayHelper.dp2px(this, 90), new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                mListPopup.dismiss();
                if (listener != null) {
                    listener.onClick(i);
                }
            }
        });
//            mListPopup.setOnDismissListener(new PopupWindow.OnDismissListener() {
//                @Override
//                public void onDismiss() {
//                }
//            });
    }


    public interface TitlePopListWindowListener {
        public void onClick(int i);


    }
}

