/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.utils;

import android.app.Activity;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.view.Window;
import com.css.sdk.cservice.base.Constants;
import java.lang.reflect.Method;

public class StatusNavUtils {
    public static void setStatusNavBar(Activity activity, int screenType) {
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.clearFlags(0xC000000);
            window.getDecorView().setSystemUiVisibility(1792);
            window.addFlags(Integer.MIN_VALUE);
            if (Build.VERSION.SDK_INT >= 23) {
                window.setStatusBarColor(0);
                window.setNavigationBarColor(0);
                StatusNavUtils.setStatusBar(activity, true);
            } else {
                if (StatusNavUtils.hasNavigationBar(activity)) {
                    StatusNavUtils.dealNavigationBar(activity, screenType);
                }
                window.setStatusBarColor(-16777216);
                window.setNavigationBarColor(-16777216);
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
            window.addFlags(0x8000000);
        }
    }

    private static void dealNavigationBar(Activity activity, int screenType) {
        if (screenType == Constants.SCREEN_TYPE_LAND || screenType == Constants.SCREEN_TYPE_REVERSE_LAND) {
            activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(0, 0, StatusNavUtils.getNavigationBarHeight(activity), 0);
        } else if (screenType == Constants.SCREEN_TYPE_PORT) {
            activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(0, 0, 0, StatusNavUtils.getNavigationBarHeight(activity));
        }
    }

    private static void setStatusBar(Activity activity, boolean dark) {
        View decor = activity.getWindow().getDecorView();
        if (dark) {
            decor.setSystemUiVisibility(9216);
        } else {
            decor.setSystemUiVisibility(1280);
        }
    }

    private static int getNavigationBarHeight(Activity mActivity) {
        Resources resources = mActivity.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    public static boolean hasNavigationBar(Activity context) {
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasNavigationBar;
    }
}

