/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.inputmethod.InputMethodManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Utils {
    public static ArrayList getShuffleList(Collection collection) {
        if (collection == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(collection);
        Collections.shuffle(list);
        return list;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int getResId(Context context, String type, String name) {
        int id2 = context.getResources().getIdentifier(name, type, context.getPackageName());
        return id2;
    }

    public static void openActionView(Context context, String string2) {
        Uri uri = Uri.parse((String)string2);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        context.startActivity(intent);
    }

    public static boolean isNotificationEnable(Context context) {
        if (context == null) {
            return false;
        }
        NotificationManagerCompat manager = NotificationManagerCompat.from((Context)context);
        return manager.areNotificationsEnabled();
    }

    public static void goToNotification(Context context) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    public static void hideKeyboard(Context context, IBinder token) {
        if (token != null && context != null) {
            InputMethodManager im = (InputMethodManager)context.getSystemService("input_method");
            im.hideSoftInputFromWindow(token, 2);
        }
    }

    public static Drawable getDrawable(Context context, int resid) {
        Drawable mDrawable = Build.VERSION.SDK_INT >= 21 ? ContextCompat.getDrawable((Context)context, (int)resid) : context.getResources().getDrawable(resid);
        return mDrawable;
    }

    public static String readMetaDataFromApplication(Context context, String name) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            String mTag = appInfo.metaData.getString(name);
            return mTag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

