/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class HttpResponse {
    private static HttpURLConnection conn;

    public HttpResponse(HttpURLConnection conn) throws Exception {
        if (conn == null) {
            throw new IOException("HttpURLConnection is null");
        }
        HttpResponse.conn = conn;
    }

    public int getResponseCode() throws Exception {
        int code = conn.getResponseCode();
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBody() throws Exception {
        String body = "";
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            int count;
            is = conn.getInputStream();
            os = new ByteArrayOutputStream();
            int size = 1024;
            byte[] bf = new byte[size];
            while ((count = is.read(bf)) != -1) {
                os.write(bf, 0, count);
            }
            body = os.toString("UTF-8");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.free();
        }
        return body;
    }

    public void free() {
        try {
            conn.disconnect();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

