/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.data.ImageFloder;
import com.css.sdk.cservice.imageloader.ImageLoader;
import java.util.ArrayList;
import java.util.List;

public class PictureAlbumDirectoryAdapter
extends BaseAdapter {
    private Context context;
    private OnItemClickListener onItemClickListener;
    private List<ImageFloder> folders = new ArrayList<ImageFloder>();

    public void bindFolderData(List<ImageFloder> folders) {
        this.folders = folders;
        this.notifyDataSetChanged();
    }

    public List<ImageFloder> getFolderData() {
        if (this.folders == null) {
            this.folders = new ArrayList<ImageFloder>();
        }
        return this.folders;
    }

    public PictureAlbumDirectoryAdapter(Context context) {
        this.context = context;
    }

    public int getCount() {
        return this.folders.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        final ImageFloder folder = this.folders.get(position);
        String name = folder.getName();
        int imageNum = folder.images.size();
        String imagePath = folder.getFirstImagePath();
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.css_picture_album_folder_item, null);
            holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        ImageLoader.getInstance().load(imagePath, holder.firstImage);
        holder.imageNum.setText((CharSequence)("(" + imageNum + ")"));
        holder.folderNameTv.setText((CharSequence)name);
        holder.choose.setVisibility(folder.isChecked() ? 0 : 8);
        holder.itemRl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PictureAlbumDirectoryAdapter.this.onItemClickListener != null) {
                    for (ImageFloder mediaFolder : PictureAlbumDirectoryAdapter.this.folders) {
                        mediaFolder.setChecked(false);
                    }
                    folder.setChecked(true);
                    PictureAlbumDirectoryAdapter.this.notifyDataSetChanged();
                    PictureAlbumDirectoryAdapter.this.onItemClickListener.onItemClick(folder.getName(), folder);
                }
            }
        });
        return convertView;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1, ImageFloder var2);
    }

    class ViewHolder {
        ImageView firstImage;
        TextView folderNameTv;
        TextView imageNum;
        RelativeLayout itemRl;
        ImageView choose;

        public ViewHolder(View view) {
            this.firstImage = (ImageView)view.findViewById(R.id.css_folder_first_image);
            this.folderNameTv = (TextView)view.findViewById(R.id.css_tv_folder_name);
            this.imageNum = (TextView)view.findViewById(R.id.css_pics_num);
            this.itemRl = (RelativeLayout)view.findViewById(R.id.css_album_item_rl);
            this.choose = (ImageView)view.findViewById(R.id.css_folder_choose);
        }
    }
}

