/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.css.sdk.R;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnItemClickListener;
import com.luck.picture.lib.tools.DateUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GridImageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    public static final String TAG = "PictureSelector";
    public static final int TYPE_CAMERA = 1;
    public static final int TYPE_PICTURE = 2;
    private LayoutInflater mInflater;
    private List<LocalMedia> list = new ArrayList<LocalMedia>();
    private int selectMax = 3;
    private onAddPicClickListener mOnAddPicClickListener;
    private picDeleteListener picDeleteListener;
    private OnItemClickListener mItemClickListener;

    public void delete(int position) {
        try {
            if (position != -1 && this.list.size() > position) {
                this.list.remove(position);
                this.notifyItemRemoved(position);
                this.notifyItemRangeChanged(position, this.list.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GridImageAdapter(Context context, onAddPicClickListener mOnAddPicClickListener) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mOnAddPicClickListener = mOnAddPicClickListener;
    }

    public void setSelectMax(int selectMax) {
        this.selectMax = selectMax;
    }

    public void setList(List<LocalMedia> list) {
        this.list = list;
    }

    public List<LocalMedia> getData() {
        return this.list == null ? new ArrayList() : this.list;
    }

    public void remove(int position) {
        if (this.list != null) {
            this.list.remove(position);
        }
    }

    public void setPicDeleteListener(picDeleteListener picDeleteListener2) {
        this.picDeleteListener = picDeleteListener2;
    }

    public int getItemCount() {
        if (this.list.size() < this.selectMax) {
            return this.list.size() + 1;
        }
        return this.list.size();
    }

    public int getItemViewType(int position) {
        if (this.isShowAddItem(position)) {
            return 1;
        }
        return 2;
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        View view = this.mInflater.inflate(R.layout.gv_filter_image, viewGroup, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    private boolean isShowAddItem(int position) {
        int size = this.list.size() == 0 ? 0 : this.list.size();
        return position == size;
    }

    public void onBindViewHolder(final ViewHolder viewHolder, int position) {
        if (this.getItemViewType(position) == 1) {
            viewHolder.mImg.setImageResource(R.drawable.css_icon_add_pic);
            viewHolder.mImg.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GridImageAdapter.this.mOnAddPicClickListener.onAddPicClick();
                }
            });
            viewHolder.mIvDel.setVisibility(4);
        } else {
            viewHolder.mIvDel.setVisibility(0);
            viewHolder.mIvDel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int index = viewHolder.getAdapterPosition();
                    if (index != -1 && GridImageAdapter.this.list.size() > index) {
                        GridImageAdapter.this.list.remove(index);
                        GridImageAdapter.this.notifyItemRemoved(index);
                        GridImageAdapter.this.notifyItemRangeChanged(index, GridImageAdapter.this.list.size());
                    }
                    if (GridImageAdapter.this.picDeleteListener != null) {
                        GridImageAdapter.this.picDeleteListener.deleted(index);
                    }
                }
            });
            LocalMedia media = this.list.get(position);
            if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) {
                return;
            }
            int chooseModel = media.getChooseModel();
            String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
            LogUtils.i("\u539f\u56fe\u5730\u5740::" + media.getPath());
            if (media.isCut()) {
                LogUtils.i("\u88c1\u526a\u5730\u5740::" + media.getCutPath());
            }
            if (media.isCompressed()) {
                LogUtils.i("\u538b\u7f29\u5730\u5740::" + media.getCompressPath());
                LogUtils.i("\u538b\u7f29\u540e\u6587\u4ef6\u5927\u5c0f::" + new File(media.getCompressPath()).length() / 1024L + "k");
            }
            if (!TextUtils.isEmpty((CharSequence)media.getAndroidQToPath())) {
                LogUtils.i("Android Q\u7279\u6709\u5730\u5740::" + media.getAndroidQToPath());
            }
            if (media.isOriginal()) {
                LogUtils.i("\u662f\u5426\u5f00\u542f\u539f\u56fe\u529f\u80fd::true");
                LogUtils.i("\u5f00\u542f\u539f\u56fe\u529f\u80fd\u540e\u5730\u5740::" + media.getOriginalPath());
            }
            long duration = media.getDuration();
            viewHolder.tvDuration.setVisibility(PictureMimeType.eqVideo((String)media.getMimeType()) ? 0 : 8);
            if (chooseModel == PictureMimeType.ofAudio()) {
                viewHolder.tvDuration.setVisibility(0);
                viewHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.css_picture_icon_audio, 0, 0, 0);
            } else {
                viewHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.css_picture_icon_video, 0, 0, 0);
            }
            viewHolder.tvDuration.setText((CharSequence)DateUtils.formatDurationTime((long)duration));
            if (chooseModel == PictureMimeType.ofAudio()) {
                viewHolder.mImg.setImageResource(R.drawable.css_picture_audio_placeholder);
            } else {
                Glide.with((Context)viewHolder.itemView.getContext()).load(PictureMimeType.isContent((String)path) && !media.isCut() && !media.isCompressed() ? Uri.parse((String)path) : path).into(viewHolder.mImg);
            }
            if (this.mItemClickListener != null) {
                viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int adapterPosition = viewHolder.getAdapterPosition();
                        GridImageAdapter.this.mItemClickListener.onItemClick(v, adapterPosition);
                    }
                });
            }
        }
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mImg;
        ImageView mIvDel;
        TextView tvDuration;

        public ViewHolder(View view) {
            super(view);
            this.mImg = (ImageView)view.findViewById(R.id.fiv);
            this.mIvDel = (ImageView)view.findViewById(R.id.iv_del);
            this.tvDuration = (TextView)view.findViewById(R.id.tv_duration);
        }
    }

    public static interface picDeleteListener {
        public void deleted(int var1);
    }

    public static interface onAddPicClickListener {
        public void onAddPicClick();
    }
}

