/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.FaqDetailActvity;
import com.css.sdk.cservice.activity.FeedBaseActivity;
import com.css.sdk.cservice.activity.SubmitSuccessActivity;
import com.css.sdk.cservice.adapter.CssTextGridViewAdapter;
import com.css.sdk.cservice.adapter.GridImageAdapter;
import com.css.sdk.cservice.adapter.RecommendQaAapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.view.CssRoundBtn;
import java.util.List;
import org.json.JSONObject;

public class FeedBackActivity
extends FeedBaseActivity
implements CssTextGridViewAdapter.GridViewItemClickListener,
GridImageAdapter.picDeleteListener,
RecommendQaAapter.RecommendQAItemClickListener {
    private CssRoundBtn feedbackBtn;
    private LinearLayout rootLl;
    private RelativeLayout titleTvRoot;
    private GridView mGridView;
    private CssTextGridViewAdapter mGridAdapter;
    private String selectedQaType = "1";
    private boolean hasShow;
    private RecommendQaAapter recommendQaAapter;
    private List<FaqItem> faqList;
    private LinearLayout subLoadingView;
    public boolean mSubLoading;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getWindow().getDecorView().setImportantForAutofill(8);
        }
        super.onCreate(savedInstanceState);
        this.initView();
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_feed_back;
    }

    private void initView() {
        this.mGridView = (GridView)this.findViewById(R.id.css_faqtag_gridView);
        this.mGridAdapter = new CssTextGridViewAdapter((Context)this, 0, GlobalData.getTypeItems(), this);
        this.mGridView.setAdapter((ListAdapter)this.mGridAdapter);
        this.hideTitleBack();
        this.showTitleName(R.string.css_text_submit_qa);
        this.showTitleClose();
        this.subLoadingView = (LinearLayout)this.findViewById(R.id.listview_loading);
        this.rootLl = (LinearLayout)this.findViewById(R.id.css_feedback_root);
        this.feedbackBtn = (CssRoundBtn)this.findViewById(R.id.css_btn_submit_qa);
        this.feedbackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FeedBackActivity.this.feedBack();
            }
        });
        this.recommendQaAapter = new RecommendQaAapter((Context)this, this);
        this.checkSpHelper();
        this.hasShow = this.spHelper.getBooleanWithDefault(Constants.RECOMMENDED_QA_SHOW, true);
        this.mSelectedPicsAdapter.setPicDeleteListener(this);
    }

    private void hideTitleBack() {
        this.titleBack = (RelativeLayout)this.findViewById(R.id.css_title_back);
        this.titleBack.setVisibility(8);
        this.titleBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FeedBackActivity.this.finish();
            }
        });
    }

    private void showTitleName(int resId) {
        this.titleTvRoot = (RelativeLayout)this.findViewById(R.id.rl_titile_text);
        this.titleTvRoot.setVisibility(0);
        TextView titleTv = (TextView)this.findViewById(R.id.css_title_tv);
        titleTv.setText((CharSequence)this.getResources().getString(resId));
    }

    private void showTitleClose() {
        RelativeLayout closeRoot = (RelativeLayout)this.findViewById(R.id.css_title_close);
        closeRoot.setVisibility(0);
        closeRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FeedBackActivity.this.finish();
            }
        });
    }

    private void feedBack() {
        if (this.isContentEmpty()) {
            return;
        }
        if (this.mLoading) {
            return;
        }
        this.showLoading();
        BusinessRequest.feedBackN((Context)this, "", this.picNames, this.videoNames, this.cancelPics, Integer.parseInt(this.selectedQaType), "", this.etFeedbackContent.getText().toString().trim(), new RequestCallback<String>(){

            @Override
            public void onSuccess(final String result) {
                FeedBackActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FeedBackActivity.this.hideLoading();
                        try {
                            JSONObject jsonObject = new JSONObject(result);
                            String msg = jsonObject.optString("message");
                            if (!msg.equals("SUCCESS")) {
                                FeedBackActivity.this.showError(0);
                                return;
                            }
                            Intent intent = new Intent((Context)FeedBackActivity.this, SubmitSuccessActivity.class);
                            intent.putExtra("result", result);
                            FeedBackActivity.this.startActivity(intent);
                            FeedBackActivity.this.clearData();
                            FeedBackActivity.this.finish();
                        }
                        catch (Exception e) {
                            FeedBackActivity.this.showError(e.getMessage());
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FeedBackActivity.this.hideLoading();
                FeedBackActivity.this.showError(code);
            }
        });
    }

    protected void onDestroy() {
        if (GlobalData.getIsSensorLand()) {
            this.setRequestedOrientation(6);
        }
        this.getWindow().getDecorView().findViewById(0x1020002).setPadding(0, 0, 0, 0);
        super.onDestroy();
    }

    private void getFaqListMatch(String content) {
        this.showSubLoading();
        BusinessRequest.getFaqMatchList(content, new RequestCallback<List<FaqItem>>(){

            @Override
            public void onSuccess(final List<FaqItem> result) {
                FeedBackActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (result.isEmpty()) {
                            return;
                        }
                        FeedBackActivity.this.faqList = result;
                        if (FeedBackActivity.this.hasShow) {
                            FeedBackActivity.this.recommendQaAapter.bindData(result);
                        }
                        FeedBackActivity.this.hideSubLoading();
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FeedBackActivity.this.hideLoading();
                FeedBackActivity.this.showError(code);
            }
        });
    }

    public void showSubLoading() {
        this.mSubLoading = true;
    }

    public void hideSubLoading() {
        this.mSubLoading = false;
    }

    @Override
    public void showLoading() {
        super.showLoading();
    }

    @Override
    public void hideLoading() {
        super.hideLoading();
    }

    @Override
    public void onItemClick(int position, FaqItem faqItem) {
        Intent i = new Intent((Context)this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, faqItem.id);
        this.startActivity(i);
    }

    @Override
    public void onGridItemClick(int id2) {
        this.selectedQaType = GlobalData.getTypeItems().get(id2).getId();
    }

    @Override
    public void deleted(int postion) {
        this.cancelPics.add(this.picNames.get(postion));
        if (this.picNames.contains(this.picNames.get(postion))) {
            this.picNames.remove(this.picNames.get(postion));
        }
    }
}

