/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.http;

import android.text.TextUtils;
import com.css.sdk.cservice.base.http.HttpClient;
import com.css.sdk.cservice.base.http.HttpResponse;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.luck.picture.lib.entity.LocalMedia;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HttpClientHelper {
    private static int UPLOAD_TIMEOUT = 120000;

    public static HttpResponse httpGet(String url, String userAgent) throws Exception {
        return HttpClientHelper.httpSend("get", url, null, userAgent, null);
    }

    public static HttpResponse httpPost(String url, String requestBody, String userAgent) throws Exception {
        return HttpClientHelper.httpSend("post", url, requestBody, userAgent, null);
    }

    public static HttpResponse httpPost(String url, String requestBody, String userAgent, String enctyType) throws Exception {
        return HttpClientHelper.httpSend("post", url, requestBody, userAgent, enctyType);
    }

    public static HttpResponse httpPost(String url, String requestBody, Map<String, String> heardMap, String userAgent, String enctyType) throws Exception {
        return HttpClientHelper.httpSend("post", url, requestBody, heardMap, userAgent, enctyType);
    }

    public static HttpResponse httpUpload(String url, Map<String, String> params, List<String> files) throws Exception {
        HttpResponse body = null;
        HttpClient client = HttpClient.builder().setUrl(url);
        client.setConnectTimeout(UPLOAD_TIMEOUT);
        client.setReadTimeout(UPLOAD_TIMEOUT);
        client.setUseCaches(false);
        body = client.requestUpload(params, files);
        return body;
    }

    public static void httpDownLoad(String httpUrl, String filePath, DownLoadListener downLoadListener) throws Exception {
        HttpClientHelper.downloadFile(httpUrl, filePath, downLoadListener);
    }

    private static HttpResponse httpSend(String type, String url, String requestBody, String userAgent, String enctyType) throws Exception {
        HttpResponse body = null;
        HttpClient client = HttpClient.builder().setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod(HttpClient.METHOD_POST);
        }
        if (!TextUtils.isEmpty((CharSequence)requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty((CharSequence)enctyType)) {
            client.setEnctyType(enctyType);
        }
        body = client.request();
        return body;
    }

    private static HttpResponse httpSend(String type, String url, String requestBody, Map<String, String> headerMap, String userAgent, String enctyType) throws Exception {
        HttpResponse body = null;
        HttpClient client = HttpClient.builder().setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod(HttpClient.METHOD_POST);
        }
        if (!TextUtils.isEmpty((CharSequence)requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty((CharSequence)enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (!TextUtils.isEmpty((CharSequence)enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (headerMap != null && headerMap.size() != 0) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                client.setRequestHeader(key, value);
            }
        }
        body = client.request();
        return body;
    }

    private static void downloadFile(String httpUrl, String filePath, DownLoadListener downLoadListener) {
        try {
            FileOutputStream fos;
            URL url = new URL(httpUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(5000);
            urlConn.setReadTimeout(5000);
            urlConn.setUseCaches(true);
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.addRequestProperty("Connection", "Keep-Alive");
            urlConn.connect();
            if (urlConn.getResponseCode() == 200) {
                int len;
                File descFile = new File(filePath);
                fos = new FileOutputStream(descFile);
                byte[] buffer = new byte[1024];
                InputStream inputStream = urlConn.getInputStream();
                while ((len = inputStream.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
            } else {
                downLoadListener.onFail("fail in download video, error : " + urlConn.getResponseCode());
                LogUtils.i("fail in download video, error : " + urlConn.getResponseCode());
                return;
            }
            fos.close();
            if (downLoadListener != null) {
                LocalMedia localMedia = new LocalMedia();
                localMedia.setPath(filePath);
                localMedia.setMimeType("video/mp4");
                downLoadListener.onSuccess(localMedia);
            }
            urlConn.disconnect();
        }
        catch (Exception e) {
            if (downLoadListener != null) {
                downLoadListener.onFail("has error in download video " + e.getMessage());
            }
            LogUtils.i("has error in download video " + e.getMessage());
        }
    }

    public static interface DownLoadListener {
        public void onSuccess(LocalMedia var1);

        public void onFail(String var1);
    }
}

