package com.css.sdk.cservice.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.PictureAlbumDirectoryAdapter;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;
import com.css.sdk.cservice.base.utils.Utils;
import com.css.sdk.cservice.data.ImageFloder;

import java.util.List;

public class FolderPopWindow extends PopupWindow implements View.OnClickListener {
    private Context context;
    private View view;
    private ListView listView;
    private PictureAlbumDirectoryAdapter adapter;
    private Animation animationIn, animationOut;
    private boolean isDismiss = false;
    private LinearLayout rootLl;
    private TextView pictureTitle;


    public FolderPopWindow(Context context) {
        this.context = context;
        view = LayoutInflater.from(context).inflate(R.layout.css_picture_pop_window, null);
        this.setContentView(view);
        this.setWidth(DeviceInfoHelper.getScreenWidth(context));
        this.setHeight(DeviceInfoHelper.getScreenHeight(context));
        this.setAnimationStyle(R.style.WindowStyle);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        this.setBackgroundDrawable(new ColorDrawable(Color.argb(123, 0, 0, 0)));
        animationIn = AnimationUtils.loadAnimation(context, R.anim.css_album_show);
        animationOut = AnimationUtils.loadAnimation(context, R.anim.css_album_dismiss);

        rootLl = (LinearLayout) view.findViewById(R.id.css_lv_ll);
        adapter = new PictureAlbumDirectoryAdapter(context);
        listView = (ListView) view.findViewById(R.id.css_folder_list);
        listView.setAdapter(adapter);
        rootLl.setOnClickListener(this);
    }

    public void bindFolder(List<ImageFloder> folders) {
        adapter.bindFolderData(folders);
    }

    public void setPictureTitleView(TextView picture_title) {
        this.pictureTitle = picture_title;
    }

    @Override
    public void showAsDropDown(View anchor) {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                Rect rect = new Rect();
                anchor.getGlobalVisibleRect(rect);
                int h = anchor.getResources().getDisplayMetrics().heightPixels - rect.bottom;
                setHeight(h);
            }
            super.showAsDropDown(anchor);
            isDismiss = false;
            listView.startAnimation(animationIn);
            modifyTextViewDrawable(pictureTitle, Utils.getDrawable(context,R.drawable.css_arrow_up));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnItemClickListener(PictureAlbumDirectoryAdapter.OnItemClickListener onItemClickListener) {
        adapter.setOnItemClickListener(onItemClickListener);
    }

    @Override
    public void dismiss() {
        if (isDismiss) {
            return;
        }
        modifyTextViewDrawable(pictureTitle, Utils.getDrawable(context,R.drawable.css_arrow_down));
        isDismiss = true;
        listView.startAnimation(animationOut);
        dismiss();
        animationOut.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                isDismiss = false;
                if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.JELLY_BEAN) {
                    dismiss4Pop();
                } else {
                    FolderPopWindow.super.dismiss();
                }
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
    }

    /**
     * 在android4.1.1和4.1.2版本关闭PopWindow
     */
    private void dismiss4Pop() {
        new Handler().post(new Runnable() {
            @Override
            public void run() {
                FolderPopWindow.super.dismiss();
            }
        });
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.css_lv_ll) {
            dismiss();
        }
    }

    public void modifyTextViewDrawable(TextView v, Drawable drawable) {
        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
        v.setCompoundDrawables(null, null, drawable, null);
    }
}
