package com.css.sdk.cservice.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * 工单详情
 */
public class OrderDetail {
    public long id;
    public String title;
    public String type;
    public String status;
    public boolean evaluated;//未评价:unknown；满意评价：y:不满意：n
    public ArrayList<Chat> chats = new ArrayList<>();

    public void parseJsonString(JSONObject jsonObject) throws Exception {
        JSONArray list = jsonObject.getJSONArray("chats");
        JSONObject row = null;
        for (int i = 0; i < list.length(); i++) {
            row = list.getJSONObject(i);
            Chat c = new Chat();
            c.parseJsonString(row);
            chats.add(c);
        }
        this.id = jsonObject.optLong("id");
        this.title = jsonObject.optString("title");
        this.type = jsonObject.optString("type");
        this.status = jsonObject.optString("status");
        String e = jsonObject.getString("evaluated");
        if(e.equals("unknown")){
            this.evaluated = false;
        }else {
            this.evaluated = true;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Chat c : chats) {
            sb.append(c.toString()).append("\n");
        }
        sb.append("]");
        return "OrderDetail{" +
                "id=" + id +
                ", status='" + status + '\'' +
                ", title='" + title + '\'' +
                ", type='" + type + '\'' +
                ", evaluated='" + evaluated + '\'' +
                ", chats='" + sb.toString() + '\'' +
                '}';
    }
}
